/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.datasource;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceFactory;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceWrapper;
import org.apache.shardingsphere.scaling.core.config.TaskConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);
    private final DataSourceFactory dataSourceFactory = new DataSourceFactory();
    private final Map<ScalingDataSourceConfiguration, DataSourceWrapper> cachedDataSources = new ConcurrentHashMap<ScalingDataSourceConfiguration, DataSourceWrapper>();
    private final Map<ScalingDataSourceConfiguration, DataSourceWrapper> sourceDataSources = new ConcurrentHashMap<ScalingDataSourceConfiguration, DataSourceWrapper>();
    private final Map<ScalingDataSourceConfiguration, DataSourceWrapper> targetDataSources = new ConcurrentHashMap<ScalingDataSourceConfiguration, DataSourceWrapper>();

    public DataSourceManager(List<TaskConfiguration> taskConfigs) {
        this.createDataSources(taskConfigs);
    }

    private void createDataSources(List<TaskConfiguration> taskConfigs) {
        this.createSourceDataSources(taskConfigs);
        this.createTargetDataSources(taskConfigs.iterator().next().getImporterConfig().getDataSourceConfig());
    }

    private void createSourceDataSources(List<TaskConfiguration> taskConfigs) {
        for (TaskConfiguration taskConfig : taskConfigs) {
            ScalingDataSourceConfiguration dataSourceConfig = taskConfig.getDumperConfig().getDataSourceConfig();
            DataSourceWrapper dataSource = this.dataSourceFactory.newInstance(dataSourceConfig);
            this.cachedDataSources.put(dataSourceConfig, dataSource);
            this.sourceDataSources.put(dataSourceConfig, dataSource);
        }
    }

    private void createTargetDataSources(ScalingDataSourceConfiguration dataSourceConfig) {
        DataSourceWrapper dataSource = this.dataSourceFactory.newInstance(dataSourceConfig);
        this.cachedDataSources.put(dataSourceConfig, dataSource);
        this.targetDataSources.put(dataSourceConfig, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(ScalingDataSourceConfiguration dataSourceConfig) {
        if (this.cachedDataSources.containsKey(dataSourceConfig)) {
            return this.cachedDataSources.get(dataSourceConfig);
        }
        Map<ScalingDataSourceConfiguration, DataSourceWrapper> map = this.cachedDataSources;
        synchronized (map) {
            if (this.cachedDataSources.containsKey(dataSourceConfig)) {
                return this.cachedDataSources.get(dataSourceConfig);
            }
            DataSourceWrapper result = this.dataSourceFactory.newInstance(dataSourceConfig);
            this.cachedDataSources.put(dataSourceConfig, result);
            return result;
        }
    }

    @Override
    public void close() {
        for (DataSourceWrapper each : this.cachedDataSources.values()) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                log.error("An exception occurred while closing the data source", (Throwable)ex);
            }
        }
        this.cachedDataSources.clear();
        this.sourceDataSources.clear();
    }

    @Generated
    public DataSourceManager() {
    }

    @Generated
    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    @Generated
    public Map<ScalingDataSourceConfiguration, DataSourceWrapper> getCachedDataSources() {
        return this.cachedDataSources;
    }

    @Generated
    public Map<ScalingDataSourceConfiguration, DataSourceWrapper> getSourceDataSources() {
        return this.sourceDataSources;
    }

    @Generated
    public Map<ScalingDataSourceConfiguration, DataSourceWrapper> getTargetDataSources() {
        return this.targetDataSources;
    }
}

