/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.channel.distribution;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.channel.AckCallback;
import org.apache.shardingsphere.scaling.core.common.channel.Channel;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.AutoAcknowledgeChannel;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.BitSetChannel;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.BlockingQueueChannel;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.record.FinishedRecord;
import org.apache.shardingsphere.scaling.core.common.record.PlaceholderRecord;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributionChannel
implements Channel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributionChannel.class);
    private final int channelNumber;
    private final BitSetChannel[] channels;
    private final BitSetChannel autoAckChannel = new AutoAcknowledgeChannel();
    private final Map<String, Integer> channelAssignment = new HashMap<String, Integer>();
    private final AckCallback ackCallback;
    private final AtomicLong indexAutoIncreaseGenerator = new AtomicLong();
    private final Queue<Integer> toBeAckBitSetIndexes = new ConcurrentLinkedQueue<Integer>();
    private long lastAckIndex;
    private ScheduledExecutorService scheduleAckRecordsExecutor;

    public DistributionChannel(int channelNumber, AckCallback ackCallback) {
        this.channelNumber = channelNumber;
        this.ackCallback = ackCallback;
        this.channels = new BitSetChannel[channelNumber];
        for (int i = 0; i < channelNumber; ++i) {
            this.channels[i] = new BlockingQueueChannel();
        }
        this.scheduleAckRecords();
    }

    private void scheduleAckRecords() {
        this.scheduleAckRecordsExecutor = Executors.newSingleThreadScheduledExecutor();
        this.scheduleAckRecordsExecutor.scheduleWithFixedDelay(this::ackRecords0, 5L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void pushRecord(Record record) throws InterruptedException {
        if (FinishedRecord.class.equals(record.getClass())) {
            for (int i = 0; i < this.channels.length; ++i) {
                this.pushRecord(record, i);
            }
        } else if (DataRecord.class.equals(record.getClass())) {
            this.pushRecord(record, Math.abs(record.hashCode() % this.channelNumber));
        } else if (PlaceholderRecord.class.equals(record.getClass())) {
            this.pushRecord(record, -1);
        } else {
            throw new RuntimeException("Not Support Record Type");
        }
    }

    private void pushRecord(Record record, int index) throws InterruptedException {
        this.toBeAckBitSetIndexes.add(index);
        this.getBitSetChannel(index).pushRecord(record, this.indexAutoIncreaseGenerator.getAndIncrement());
    }

    @Override
    public List<Record> fetchRecords(int batchSize, int timeout) {
        return this.findChannel().fetchRecords(batchSize, timeout);
    }

    @Override
    public void ack() {
        this.findChannel().ack();
    }

    private synchronized void ackRecords0() {
        try {
            int count = this.shouldAckCount();
            if (0 == count) {
                return;
            }
            this.ackCallback.onAck(this.fetchAckRecords(count));
            this.lastAckIndex += (long)count;
            for (BitSetChannel channel : this.channels) {
                channel.clear(this.lastAckIndex);
            }
        }
        catch (Exception ex) {
            log.error("distribution channel auto ack failed.", (Throwable)ex);
        }
    }

    private int shouldAckCount() {
        BitSet bitSet = this.autoAckChannel.getAckBitSet(this.lastAckIndex);
        for (BitSetChannel channel : this.channels) {
            bitSet.or(channel.getAckBitSet(this.lastAckIndex));
        }
        return bitSet.nextClearBit(0);
    }

    private List<Record> fetchAckRecords(int count) {
        LinkedList<Record> result = new LinkedList<Record>();
        for (int i = 0; i < count; ++i) {
            result.add(this.getBitSetChannel(this.toBeAckBitSetIndexes.remove()).removeAckRecord());
        }
        return result;
    }

    private BitSetChannel getBitSetChannel(Integer index) {
        return index == -1 ? this.autoAckChannel : this.channels[index];
    }

    private BitSetChannel findChannel() {
        String threadId = Long.toString(Thread.currentThread().getId());
        this.checkAssignment(threadId);
        return this.channels[this.channelAssignment.get(threadId)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAssignment(String threadId) {
        if (!this.channelAssignment.containsKey(threadId)) {
            DistributionChannel distributionChannel = this;
            synchronized (distributionChannel) {
                if (!this.channelAssignment.containsKey(threadId)) {
                    this.assignmentChannel(threadId);
                }
            }
        }
    }

    private void assignmentChannel(String threadId) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channelAssignment.containsValue(i)) continue;
            this.channelAssignment.put(threadId, i);
            return;
        }
    }

    @Override
    public void close() {
        this.scheduleAckRecordsExecutor.shutdown();
        this.ackRecords0();
        for (BitSetChannel each : this.channels) {
            each.close();
        }
        this.toBeAckBitSetIndexes.clear();
    }
}

