/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.channel.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.AbstractBitSetChannel;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.util.ThreadUtil;

public final class BlockingQueueChannel
extends AbstractBitSetChannel {
    private final BlockingQueue<Record> queue = new ArrayBlockingQueue<Record>(ScalingContext.getInstance().getServerConfig().getBlockQueueSize());
    private long fetchedIndex;

    @Override
    public void pushRecord(Record dataRecord, long index) throws InterruptedException {
        this.getManualBitSet().set(index);
        this.queue.put(dataRecord);
    }

    @Override
    public List<Record> fetchRecords(int batchSize, int timeout) {
        ArrayList<Record> result = new ArrayList<Record>(batchSize);
        long start = System.currentTimeMillis();
        while (batchSize > this.queue.size() && (long)timeout * 1000L > System.currentTimeMillis() - start) {
            ThreadUtil.sleep(100L);
        }
        this.queue.drainTo(result, batchSize);
        this.getToBeAckRecords().addAll(result);
        this.fetchedIndex = this.getManualBitSet().getEndIndex(this.fetchedIndex, result.size());
        return result;
    }

    @Override
    public void ack() {
        this.setAcknowledgedIndex(this.fetchedIndex);
    }

    @Override
    public void close() {
        this.queue.clear();
        super.close();
    }
}

