/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.channel.distribution;

import java.util.BitSet;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.BitSetChannel;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.ManualBitSet;
import org.apache.shardingsphere.scaling.core.common.record.Record;

public abstract class AbstractBitSetChannel
implements BitSetChannel {
    private final Deque<Record> toBeAckRecords = new ConcurrentLinkedDeque<Record>();
    private final ManualBitSet manualBitSet = new ManualBitSet();
    private long acknowledgedIndex;

    @Override
    public BitSet getAckBitSet(long fromIndex) {
        return this.manualBitSet.get(fromIndex, this.acknowledgedIndex);
    }

    @Override
    public Record removeAckRecord() {
        return this.toBeAckRecords.remove();
    }

    @Override
    public void clear(long index) {
        this.manualBitSet.clear(index);
    }

    @Override
    public void close() {
        this.toBeAckRecords.clear();
    }

    @Generated
    protected Deque<Record> getToBeAckRecords() {
        return this.toBeAckRecords;
    }

    @Generated
    protected ManualBitSet getManualBitSet() {
        return this.manualBitSet;
    }

    @Generated
    protected long getAcknowledgedIndex() {
        return this.acknowledgedIndex;
    }

    @Generated
    protected void setAcknowledgedIndex(long acknowledgedIndex) {
        this.acknowledgedIndex = acknowledgedIndex;
    }
}

