/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.channel;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.shardingsphere.scaling.core.common.channel.AckCallback;
import org.apache.shardingsphere.scaling.core.common.channel.Channel;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.util.ThreadUtil;

public final class MemoryChannel
implements Channel {
    private final BlockingQueue<Record> queue = new ArrayBlockingQueue<Record>(ScalingContext.getInstance().getServerConfig().getBlockQueueSize());
    private final AckCallback ackCallback;
    private final List<Record> toBeAcknowledgeRecords = new LinkedList<Record>();

    public MemoryChannel(AckCallback ackCallback) {
        this.ackCallback = ackCallback;
    }

    @Override
    public void pushRecord(Record dataRecord) throws InterruptedException {
        this.queue.put(dataRecord);
    }

    @Override
    public List<Record> fetchRecords(int batchSize, int timeout) {
        ArrayList<Record> result = new ArrayList<Record>(batchSize);
        long start = System.currentTimeMillis();
        while (batchSize > this.queue.size() && (long)timeout * 1000L > System.currentTimeMillis() - start) {
            ThreadUtil.sleep(100L);
        }
        this.queue.drainTo(result, batchSize);
        this.toBeAcknowledgeRecords.addAll(result);
        return result;
    }

    @Override
    public void ack() {
        if (!this.toBeAcknowledgeRecords.isEmpty()) {
            this.ackCallback.onAck(this.toBeAcknowledgeRecords);
            this.toBeAcknowledgeRecords.clear();
        }
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

