/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.api.SingleTableDataCalculator;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.exception.ServiceLoaderInstantiationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleTableDataCalculatorRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleTableDataCalculatorRegistry.class);
    private static final Map<String, Map<String, SingleTableDataCalculator>> ALGORITHM_DATABASE_CALCULATOR_MAP = new HashMap<String, Map<String, SingleTableDataCalculator>>();

    public static SingleTableDataCalculator newServiceInstance(String algorithmType, String databaseType) {
        Map<String, SingleTableDataCalculator> calculatorMap = ALGORITHM_DATABASE_CALCULATOR_MAP.get(algorithmType);
        Preconditions.checkNotNull(calculatorMap, (Object)String.format("calculator not found for algorithmType '%s'", algorithmType));
        SingleTableDataCalculator calculator = calculatorMap.get(databaseType);
        Preconditions.checkNotNull((Object)calculator, (Object)String.format("calculator not found for algorithmType '%s' databaseType '%s'", algorithmType, databaseType));
        try {
            return (SingleTableDataCalculator)calculator.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ServiceLoaderInstantiationException(calculator.getClass(), (Exception)ex);
        }
    }

    static {
        ShardingSphereServiceLoader.register(SingleTableDataCalculator.class);
        for (SingleTableDataCalculator each : ShardingSphereServiceLoader.getSingletonServiceInstances(SingleTableDataCalculator.class)) {
            SingleTableDataCalculator replaced = ALGORITHM_DATABASE_CALCULATOR_MAP.computeIfAbsent(each.getAlgorithmType(), algorithmType -> new HashMap()).put(each.getDatabaseType(), each);
            if (null == replaced) continue;
            log.info("element replaced, algorithmType={}, databaseType={}, current={}, replaced={}", new Object[]{each.getAlgorithmType(), each.getDatabaseType(), each.getClass().getName(), replaced.getClass().getName()});
        }
    }
}

