/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.api.ScalingClusterAutoSwitchAlgorithm;

public final class ScalingIdleClusterAutoSwitchAlgorithm
implements ScalingClusterAutoSwitchAlgorithm {
    static final String IDLE_THRESHOLD_KEY = "incremental-task-idle-minute-threshold";
    private Properties props = new Properties();
    private long incrementalTaskIdleMinuteThreshold = 30L;

    public void init() {
        Preconditions.checkArgument((boolean)this.props.containsKey(IDLE_THRESHOLD_KEY), (String)"%s can not be null.", (Object)IDLE_THRESHOLD_KEY);
        this.incrementalTaskIdleMinuteThreshold = Long.parseLong(this.props.getProperty(IDLE_THRESHOLD_KEY));
        Preconditions.checkArgument((this.incrementalTaskIdleMinuteThreshold > 0L ? 1 : 0) != 0, (String)"%s value must be positive.", (Object)IDLE_THRESHOLD_KEY);
    }

    public String getType() {
        return "IDLE";
    }

    @Override
    public boolean allIncrementalTasksAlmostFinished(Collection<Long> incrementalTaskIdleMinutes) {
        if (null == incrementalTaskIdleMinutes || incrementalTaskIdleMinutes.isEmpty()) {
            return false;
        }
        return incrementalTaskIdleMinutes.stream().allMatch(idleMinute -> idleMinute >= this.incrementalTaskIdleMinuteThreshold);
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public long getIncrementalTaskIdleMinuteThreshold() {
        return this.incrementalTaskIdleMinuteThreshold;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setIncrementalTaskIdleMinuteThreshold(long incrementalTaskIdleMinuteThreshold) {
        this.incrementalTaskIdleMinuteThreshold = incrementalTaskIdleMinuteThreshold;
    }
}

