/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.scaling.core.api.ScalingDataConsistencyCheckAlgorithm;
import org.apache.shardingsphere.scaling.core.api.SingleTableDataCalculator;
import org.apache.shardingsphere.scaling.core.api.impl.SingleTableDataCalculatorRegistry;

public final class ScalingDefaultDataConsistencyCheckAlgorithm
implements ScalingDataConsistencyCheckAlgorithm {
    public static final String TYPE = "DEFAULT";
    private static final Collection<String> SUPPORTED_DATABASE_TYPES = Collections.singletonList(new MySQLDatabaseType().getName());

    public void init() {
    }

    @Override
    public String getDescription() {
        return "Default implementation with CRC32 of all records.";
    }

    @Override
    public Collection<String> getSupportedDatabaseTypes() {
        return SUPPORTED_DATABASE_TYPES;
    }

    @Override
    public String getProvider() {
        return "ShardingSphere";
    }

    @Override
    public SingleTableDataCalculator getSingleTableDataCalculator(String supportedDatabaseType) {
        return SingleTableDataCalculatorRegistry.newServiceInstance(TYPE, supportedDatabaseType);
    }

    public String getType() {
        return TYPE;
    }
}

