/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api.impl;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingTaskFinishedEvent;
import org.apache.shardingsphere.scaling.core.api.DataConsistencyCheckAlgorithmInfo;
import org.apache.shardingsphere.scaling.core.api.JobInfo;
import org.apache.shardingsphere.scaling.core.api.ScalingAPI;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.api.ScalingDataConsistencyCheckAlgorithm;
import org.apache.shardingsphere.scaling.core.common.exception.DataCheckFailException;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingJobCreationException;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingJobNotFoundException;
import org.apache.shardingsphere.scaling.core.config.HandleConfiguration;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.config.WorkflowConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfigurationWrap;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.ScalingJob;
import org.apache.shardingsphere.scaling.core.job.check.EnvironmentCheckerFactory;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyChecker;
import org.apache.shardingsphere.scaling.core.job.environment.ScalingEnvironmentManager;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.schedule.JobSchedulerCenter;
import org.apache.shardingsphere.scaling.core.util.JobConfigurationUtil;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingAPIImpl
implements ScalingAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingAPIImpl.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    public List<JobInfo> list() {
        return this.getJobBriefInfos().map(each -> this.getJobInfo(each.getJobName())).collect(Collectors.toList());
    }

    private Stream<JobBriefInfo> getJobBriefInfos() {
        return ScalingAPIFactory.getJobStatisticsAPI().getAllJobsBriefInfo().stream().filter(each -> !each.getJobName().startsWith("_"));
    }

    private JobInfo getJobInfo(String jobName) {
        JobInfo result = new JobInfo(Long.parseLong(jobName));
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(result.getJobId());
        JobConfiguration jobConfig = this.getJobConfig(jobConfigPOJO);
        result.setActive(!jobConfigPOJO.isDisabled());
        result.setShardingTotalCount(jobConfig.getHandleConfig().getShardingTotalCount());
        result.setTables(jobConfig.getHandleConfig().getLogicTables());
        result.setCreateTime(jobConfigPOJO.getProps().getProperty("create_time"));
        result.setStopTime(jobConfigPOJO.getProps().getProperty("stop_time"));
        result.setJobParameter(jobConfigPOJO.getJobParameter());
        return result;
    }

    @Override
    public List<Long> getUncompletedJobIds(String schemaName) {
        return this.getJobBriefInfos().filter(each -> {
            long jobId = Long.parseLong(each.getJobName());
            return this.isUncompletedJobOfSchema(schemaName, jobId);
        }).map(each -> Long.parseLong(each.getJobName())).collect(Collectors.toList());
    }

    private boolean isUncompletedJobOfSchema(String schemaName, long jobId) {
        WorkflowConfiguration workflowConfig;
        JobConfigurationPOJO jobConfigPOJO;
        try {
            jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        }
        catch (ScalingJobNotFoundException ex) {
            log.warn("scaling job not found, jobId={}", (Object)jobId);
            return false;
        }
        JobConfiguration jobConfig = this.getJobConfig(jobConfigPOJO);
        HandleConfiguration handleConfig = jobConfig.getHandleConfig();
        if (null == handleConfig || null == (workflowConfig = handleConfig.getWorkflowConfig())) {
            log.warn("handleConfig or workflowConfig null, jobId={}", (Object)jobId);
            return false;
        }
        if (!schemaName.equals(workflowConfig.getSchemaName())) {
            return false;
        }
        return !jobConfigPOJO.isDisabled();
    }

    @Override
    public void start(long jobId) {
        log.info("Start scaling job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().remove("stop_time");
        ScalingAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
    }

    @Override
    public Optional<Long> start(JobConfiguration jobConfig) {
        JobConfigurationUtil.fillInProperties(jobConfig);
        if (jobConfig.getHandleConfig().getShardingTotalCount() == 0) {
            log.warn("Invalid scaling job config!");
            throw new ScalingJobCreationException("handleConfig shardingTotalCount is 0");
        }
        log.info("Start scaling job by {}", (Object)jobConfig.getHandleConfig());
        ScalingAPIFactory.getGovernanceRepositoryAPI().persist(String.format("%s/%d", "/scaling", jobConfig.getHandleConfig().getJobId()), ScalingJob.class.getCanonicalName());
        ScalingAPIFactory.getGovernanceRepositoryAPI().persist(String.format("%s/%d/config", "/scaling", jobConfig.getHandleConfig().getJobId()), this.createJobConfig(jobConfig));
        return Optional.of(jobConfig.getHandleConfig().getJobId());
    }

    private String createJobConfig(JobConfiguration jobConfig) {
        JobConfigurationPOJO jobConfigPOJO = new JobConfigurationPOJO();
        jobConfigPOJO.setJobName(String.valueOf(jobConfig.getHandleConfig().getJobId()));
        jobConfigPOJO.setShardingTotalCount(jobConfig.getHandleConfig().getShardingTotalCount());
        jobConfigPOJO.setJobParameter(YamlEngine.marshal((Object)jobConfig));
        jobConfigPOJO.getProps().setProperty("create_time", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        return YamlEngine.marshal((Object)jobConfigPOJO);
    }

    @Override
    public void stop(long jobId) {
        log.info("Stop scaling job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        ScalingAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
    }

    @Override
    public void remove(long jobId) {
        log.info("Remove scaling job {}", (Object)jobId);
        ScalingAPIFactory.getJobOperateAPI().remove(String.valueOf(jobId), null);
        ScalingAPIFactory.getGovernanceRepositoryAPI().deleteJob(jobId);
    }

    @Override
    public Map<Integer, JobProgress> getProgress(long jobId) {
        return IntStream.range(0, this.getJobConfig(jobId).getHandleConfig().getShardingTotalCount()).boxed().collect(LinkedHashMap::new, (map, each) -> map.put(each, ScalingAPIFactory.getGovernanceRepositoryAPI().getJobProgress(jobId, (int)each)), HashMap::putAll);
    }

    @Override
    public void stopClusterWriteDB(long jobId) {
    }

    @Override
    public Collection<DataConsistencyCheckAlgorithmInfo> listDataConsistencyCheckAlgorithms() {
        return ShardingSphereServiceLoader.getSingletonServiceInstances(ScalingDataConsistencyCheckAlgorithm.class).stream().map(each -> {
            DataConsistencyCheckAlgorithmInfo algorithmInfo = new DataConsistencyCheckAlgorithmInfo();
            algorithmInfo.setType(each.getType());
            algorithmInfo.setDescription(each.getDescription());
            algorithmInfo.setSupportedDatabaseTypes(each.getSupportedDatabaseTypes());
            algorithmInfo.setProvider(each.getProvider());
            return algorithmInfo;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isDataConsistencyCheckNeeded() {
        return null != ScalingContext.getInstance().getDataConsistencyCheckAlgorithm();
    }

    @Override
    public Map<String, DataConsistencyCheckResult> dataConsistencyCheck(long jobId) {
        log.info("Data consistency check for job {}", (Object)jobId);
        if (!this.isDataConsistencyCheckNeeded()) {
            log.info("dataConsistencyCheckAlgorithm is not configured, data consistency check is ignored.");
            return Collections.emptyMap();
        }
        return this.dataConsistencyCheck0(jobId, ScalingContext.getInstance().getDataConsistencyCheckAlgorithm());
    }

    @Override
    public Map<String, DataConsistencyCheckResult> dataConsistencyCheck(long jobId, String algorithmType) {
        log.info("Data consistency check for job {}, algorithmType: {}", (Object)jobId, (Object)algorithmType);
        ShardingSphereAlgorithmConfiguration typedSPIConfig = new ShardingSphereAlgorithmConfiguration(algorithmType, new Properties());
        ScalingDataConsistencyCheckAlgorithm checkAlgorithm = (ScalingDataConsistencyCheckAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)typedSPIConfig, ScalingDataConsistencyCheckAlgorithm.class);
        return this.dataConsistencyCheck0(jobId, checkAlgorithm);
    }

    private Map<String, DataConsistencyCheckResult> dataConsistencyCheck0(long jobId, ScalingDataConsistencyCheckAlgorithm checkAlgorithm) {
        JobConfiguration jobConfig = this.getJobConfig(jobId);
        DataConsistencyChecker dataConsistencyChecker = EnvironmentCheckerFactory.newInstance(new JobContext(jobConfig));
        Map<String, DataConsistencyCheckResult> result = dataConsistencyChecker.countCheck();
        if (result.values().stream().allMatch(DataConsistencyCheckResult::isCountValid)) {
            Map<String, Boolean> dataCheckResult = dataConsistencyChecker.dataCheck(checkAlgorithm);
            result.forEach((key, value) -> value.setDataValid(dataCheckResult.getOrDefault(key, false)));
        }
        log.info("Scaling job {} with check algorithm '{}' data consistency checker result {}", new Object[]{jobId, checkAlgorithm.getClass().getName(), result});
        ScalingAPIFactory.getGovernanceRepositoryAPI().persistJobCheckResult(jobId, this.aggregateDataConsistencyCheckResults(jobId, result));
        return result;
    }

    @Override
    public boolean aggregateDataConsistencyCheckResults(long jobId, Map<String, DataConsistencyCheckResult> checkResultMap) {
        if (checkResultMap.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, DataConsistencyCheckResult> entry : checkResultMap.entrySet()) {
            boolean isDataValid = entry.getValue().isDataValid();
            boolean isCountValid = entry.getValue().isCountValid();
            if (isDataValid && isCountValid) continue;
            log.error("Scaling job: {}, table: {} data consistency check failed, dataValid: {}, countValid: {}", new Object[]{jobId, entry.getKey(), isDataValid, isCountValid});
            return false;
        }
        return true;
    }

    @Override
    public void switchClusterConfiguration(long jobId) {
        Optional<Boolean> checkResultOptional;
        log.info("Switch cluster configuration for job {}", (Object)jobId);
        if (!(!this.isDataConsistencyCheckNeeded() || (checkResultOptional = ScalingAPIFactory.getGovernanceRepositoryAPI().getJobCheckResult(jobId)).isPresent() && checkResultOptional.get().booleanValue())) {
            throw new DataCheckFailException("Data consistency check not finished or failed.");
        }
        JobConfiguration jobConfig = this.getJobConfig(jobId);
        Optional<Collection<JobContext>> optionalJobContexts = JobSchedulerCenter.getJobContexts(jobId);
        optionalJobContexts.ifPresent(jobContexts -> jobContexts.forEach(each -> each.setStatus(JobStatus.ALMOST_FINISHED)));
        ScalingDataSourceConfigurationWrap targetConfig = jobConfig.getRuleConfig().getTarget();
        YamlRootConfiguration yamlRootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((String)targetConfig.getParameter(), YamlRootConfiguration.class);
        WorkflowConfiguration workflowConfig = jobConfig.getHandleConfig().getWorkflowConfig();
        String ruleCacheId = null != workflowConfig ? workflowConfig.getRuleCacheId() : null;
        ScalingTaskFinishedEvent taskFinishedEvent = new ScalingTaskFinishedEvent(targetConfig.getSchemaName(), yamlRootConfig, ruleCacheId);
        ShardingSphereEventBus.getInstance().post((Object)taskFinishedEvent);
        optionalJobContexts.ifPresent(jobContexts -> jobContexts.forEach(each -> {
            each.setStatus(JobStatus.FINISHED);
            JobSchedulerCenter.persistJobProgress(each);
        }));
        this.stop(jobId);
    }

    @Override
    public void reset(long jobId) throws SQLException {
        log.info("Scaling job {} reset target table", (Object)jobId);
        ScalingAPIFactory.getGovernanceRepositoryAPI().deleteJobProgress(jobId);
        new ScalingEnvironmentManager().resetTargetTable(new JobContext(this.getJobConfig(jobId)));
    }

    @Override
    public JobConfiguration getJobConfig(long jobId) {
        return this.getJobConfig(this.getElasticJobConfigPOJO(jobId));
    }

    private JobConfiguration getJobConfig(JobConfigurationPOJO elasticJobConfigPOJO) {
        return (JobConfiguration)YamlEngine.unmarshal((String)elasticJobConfigPOJO.getJobParameter(), JobConfiguration.class);
    }

    private JobConfigurationPOJO getElasticJobConfigPOJO(long jobId) {
        try {
            return ScalingAPIFactory.getJobConfigurationAPI().getJobConfiguration(String.valueOf(jobId));
        }
        catch (NullPointerException ex) {
            throw new ScalingJobNotFoundException(String.format("Can not find scaling job %s", jobId), jobId);
        }
    }
}

