/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api.impl;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.apache.shardingsphere.scaling.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.task.incremental.IncrementalTask;
import org.apache.shardingsphere.scaling.core.job.task.incremental.IncrementalTaskProgress;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTask;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTaskProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GovernanceRepositoryAPIImpl
implements GovernanceRepositoryAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GovernanceRepositoryAPIImpl.class);
    private final ClusterPersistRepository repository;

    @Override
    public void persistJobProgress(JobContext jobContext) {
        JobProgress jobProgress = new JobProgress();
        jobProgress.setStatus(jobContext.getStatus());
        jobProgress.setDatabaseType(jobContext.getJobConfig().getHandleConfig().getDatabaseType());
        jobProgress.setIncrementalTaskProgressMap(this.getIncrementalTaskProgressMap(jobContext));
        jobProgress.setInventoryTaskProgressMap(this.getInventoryTaskProgressMap(jobContext));
        this.repository.persist(this.getOffsetPath(jobContext.getJobId(), jobContext.getShardingItem()), jobProgress.toString());
    }

    private Map<String, IncrementalTaskProgress> getIncrementalTaskProgressMap(JobContext jobContext) {
        HashMap<String, IncrementalTaskProgress> result = new HashMap<String, IncrementalTaskProgress>(jobContext.getIncrementalTasks().size(), 1.0f);
        for (IncrementalTask each : jobContext.getIncrementalTasks()) {
            result.put(each.getTaskId(), each.getProgress());
        }
        return result;
    }

    private Map<String, InventoryTaskProgress> getInventoryTaskProgressMap(JobContext jobContext) {
        HashMap<String, InventoryTaskProgress> result = new HashMap<String, InventoryTaskProgress>(jobContext.getInventoryTasks().size(), 1.0f);
        for (InventoryTask each : jobContext.getInventoryTasks()) {
            result.put(each.getTaskId(), each.getProgress());
        }
        return result;
    }

    @Override
    public JobProgress getJobProgress(long jobId, int shardingItem) {
        String data = this.repository.get(this.getOffsetPath(jobId, shardingItem));
        return Strings.isNullOrEmpty((String)data) ? null : JobProgress.init(data);
    }

    @Override
    public void persistJobCheckResult(long jobId, boolean checkSuccess) {
        log.info("persist job check result '{}' for job {}", (Object)checkSuccess, (Object)jobId);
        this.repository.persist(this.getCheckResultPath(jobId), String.valueOf(checkSuccess));
    }

    private String getCheckResultPath(long jobId) {
        return String.format("%s/%d/check/result", "/scaling", jobId);
    }

    @Override
    public Optional<Boolean> getJobCheckResult(long jobId) {
        String data = this.repository.get(this.getCheckResultPath(jobId));
        return Strings.isNullOrEmpty((String)data) ? Optional.empty() : Optional.of(Boolean.parseBoolean(data));
    }

    @Override
    public void deleteJobProgress(long jobId) {
        log.info("delete job progress {}", (Object)jobId);
        this.repository.delete(String.format("%s/%d/offset", "/scaling", jobId));
    }

    @Override
    public void deleteJob(long jobId) {
        log.info("delete job {}", (Object)jobId);
        this.repository.delete(String.format("%s/%d", "/scaling", jobId));
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        return this.repository.getChildrenKeys(key);
    }

    @Override
    public void watch(String key, DataChangedEventListener listener) {
        this.repository.watch(key, listener);
    }

    @Override
    public void persist(String key, String value) {
        this.repository.persist(key, value);
    }

    private String getOffsetPath(long jobId, int shardingItem) {
        return String.format("%s/%d/offset/%d", "/scaling", jobId, shardingItem);
    }

    @Generated
    public GovernanceRepositoryAPIImpl(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

