/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.event.StartScalingEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingTaskFinishedEvent;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.config.HandleConfiguration;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.config.RuleConfiguration;
import org.apache.shardingsphere.scaling.core.config.WorkflowConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ShardingSphereJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.executor.job.FinishedCheckJobExecutor;
import org.apache.shardingsphere.scaling.core.executor.job.ScalingJobExecutor;
import org.apache.shardingsphere.scaling.core.util.JDBCUtil;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlTableRuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingWorker.class);
    private static final ScalingWorker INSTANCE = new ScalingWorker();
    private static boolean enabled;

    public static void init() {
        ShardingSphereEventBus.getInstance().register((Object)INSTANCE);
        new FinishedCheckJobExecutor().start();
        new ScalingJobExecutor().start();
        enabled = true;
    }

    @Subscribe
    public void start(StartScalingEvent event) {
        Optional jobId;
        log.info("Start scaling job by {}", (Object)event);
        Optional<JobConfiguration> jobConfigOptional = this.createJobConfig(event);
        Optional<Object> optional = jobId = jobConfigOptional.isPresent() ? ScalingAPIFactory.getScalingAPI().start(jobConfigOptional.get()) : Optional.empty();
        if (!jobId.isPresent()) {
            log.info("Switch rule configuration immediately.");
            YamlRootConfiguration targetRootConfig = this.getYamlRootConfiguration(event.getSchemaName(), event.getTargetDataSource(), event.getTargetRule());
            ScalingTaskFinishedEvent taskFinishedEvent = new ScalingTaskFinishedEvent(event.getSchemaName(), targetRootConfig, event.getRuleCacheId());
            ShardingSphereEventBus.getInstance().post((Object)taskFinishedEvent);
        }
    }

    private Optional<JobConfiguration> createJobConfig(StartScalingEvent event) {
        YamlRootConfiguration sourceRootConfig = this.getYamlRootConfiguration(event.getSchemaName(), event.getSourceDataSource(), event.getSourceRule());
        YamlRootConfiguration targetRootConfig = this.getYamlRootConfiguration(event.getSchemaName(), event.getTargetDataSource(), event.getTargetRule());
        Optional<YamlShardingRuleConfiguration> sourceShardingConfigOptional = this.getYamlShardingRuleConfiguration(sourceRootConfig);
        Optional<YamlShardingRuleConfiguration> targetShardingConfigOptional = this.getYamlShardingRuleConfiguration(targetRootConfig);
        if (!sourceShardingConfigOptional.isPresent() || !targetShardingConfigOptional.isPresent()) {
            log.info("sourceShardingConfig or targetShardingConfig not present, ignore");
            return Optional.empty();
        }
        if (this.isShardingRulesTheSame(sourceShardingConfigOptional.get(), targetShardingConfigOptional.get())) {
            log.info("source and target sharding configuration is the same, ignore");
            return Optional.empty();
        }
        RuleConfiguration ruleConfig = this.getRuleConfiguration(sourceRootConfig, targetRootConfig);
        HandleConfiguration handleConfig = new HandleConfiguration(new WorkflowConfiguration(event.getSchemaName(), event.getRuleCacheId()));
        return Optional.of(new JobConfiguration(ruleConfig, handleConfig));
    }

    private Optional<YamlShardingRuleConfiguration> getYamlShardingRuleConfiguration(YamlRootConfiguration rootConfig) {
        return rootConfig.getRules().stream().filter(each -> each instanceof YamlShardingRuleConfiguration).map(each -> (YamlShardingRuleConfiguration)each).findFirst();
    }

    private boolean isShardingRulesTheSame(YamlShardingRuleConfiguration sourceShardingConfig, YamlShardingRuleConfiguration targetShardingConfig) {
        for (Map.Entry entry : sourceShardingConfig.getTables().entrySet()) {
            ((YamlTableRuleConfiguration)entry.getValue()).setLogicTable(null);
        }
        for (Map.Entry entry : targetShardingConfig.getTables().entrySet()) {
            ((YamlTableRuleConfiguration)entry.getValue()).setLogicTable(null);
        }
        String sourceShardingConfigYaml = YamlEngine.marshal((Object)sourceShardingConfig);
        String targetShardingConfigYaml = YamlEngine.marshal((Object)targetShardingConfig);
        return sourceShardingConfigYaml.equals(targetShardingConfigYaml);
    }

    private RuleConfiguration getRuleConfiguration(YamlRootConfiguration sourceRootConfig, YamlRootConfiguration targetRootConfig) {
        RuleConfiguration result = new RuleConfiguration();
        result.setSource(new ShardingSphereJDBCDataSourceConfiguration(sourceRootConfig).wrap());
        result.setTarget(new ShardingSphereJDBCDataSourceConfiguration(targetRootConfig).wrap());
        return result;
    }

    private YamlRootConfiguration getYamlRootConfiguration(String schemaName, String dataSources, String rules) {
        YamlRootConfiguration result = new YamlRootConfiguration();
        result.setSchemaName(schemaName);
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)dataSources, Map.class);
        this.disableSSLForMySQL(yamlDataSources);
        result.setDataSources(yamlDataSources);
        Collection yamlRuleConfigs = (Collection)YamlEngine.unmarshal((String)rules, Collection.class);
        result.setRules(yamlRuleConfigs);
        return result;
    }

    private void disableSSLForMySQL(Map<String, Map<String, Object>> yamlDataSources) {
        String jdbcUrl = (String)yamlDataSources.entrySet().iterator().next().getValue().get("jdbcUrl");
        DatabaseType databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)jdbcUrl);
        if (!(databaseType instanceof MySQLDatabaseType)) {
            return;
        }
        ImmutableMap parameters = ImmutableMap.of((Object)"useSSL", (Object)"false");
        for (Map.Entry<String, Map<String, Object>> entry : yamlDataSources.entrySet()) {
            jdbcUrl = (String)entry.getValue().get("jdbcUrl");
            entry.getValue().put("jdbcUrl", JDBCUtil.appendJDBCParameter(jdbcUrl, (Map<String, String>)parameters));
        }
    }

    @Generated
    public static boolean isEnabled() {
        return enabled;
    }
}

