/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobAPIFactory;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobConfigurationAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobOperateAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobStatisticsAPI;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.scaling.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.scaling.core.api.ScalingAPI;
import org.apache.shardingsphere.scaling.core.api.impl.GovernanceRepositoryAPIImpl;
import org.apache.shardingsphere.scaling.core.api.impl.ScalingAPIImpl;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.config.ServerConfiguration;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class ScalingAPIFactory {
    public static ScalingAPI getScalingAPI() {
        return ScalingAPIHolder.getInstance();
    }

    public static GovernanceRepositoryAPI getGovernanceRepositoryAPI() {
        return GovernanceRepositoryAPIHolder.getInstance();
    }

    public static JobStatisticsAPI getJobStatisticsAPI() {
        return ElasticJobAPIHolder.getInstance().getJobStatisticsAPI();
    }

    public static JobConfigurationAPI getJobConfigurationAPI() {
        return ElasticJobAPIHolder.getInstance().getJobConfigurationAPI();
    }

    public static JobOperateAPI getJobOperateAPI() {
        return ElasticJobAPIHolder.getInstance().getJobOperateAPI();
    }

    public static CoordinatorRegistryCenter getRegistryCenter() {
        return RegistryCenterHolder.getInstance();
    }

    private static void checkServerConfig() {
        ServerConfiguration serverConfig = ScalingContext.getInstance().getServerConfig();
        Preconditions.checkNotNull((Object)serverConfig, (Object)"Scaling server configuration is required.");
        Preconditions.checkNotNull((Object)serverConfig.getModeConfiguration(), (Object)"Mode configuration is required.");
        Preconditions.checkArgument((boolean)"Cluster".equals(serverConfig.getModeConfiguration().getType()), (Object)"Mode must be `Cluster`.");
    }

    @Generated
    private ScalingAPIFactory() {
    }

    private static final class RegistryCenterHolder {
        private static volatile CoordinatorRegistryCenter instance;

        private RegistryCenterHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static CoordinatorRegistryCenter getInstance() {
            if (null != instance) return instance;
            Class<ScalingAPIFactory> clazz = ScalingAPIFactory.class;
            synchronized (ScalingAPIFactory.class) {
                if (null != instance) return instance;
                instance = RegistryCenterHolder.createRegistryCenter();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static CoordinatorRegistryCenter createRegistryCenter() {
            ZookeeperRegistryCenter result = new ZookeeperRegistryCenter(RegistryCenterHolder.getZookeeperConfig());
            result.init();
            return result;
        }

        private static ZookeeperConfiguration getZookeeperConfig() {
            ScalingAPIFactory.checkServerConfig();
            ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)ScalingContext.getInstance().getServerConfig().getModeConfiguration().getRepository();
            ZookeeperConfiguration result = new ZookeeperConfiguration(repositoryConfig.getServerLists(), repositoryConfig.getNamespace() + "/scaling");
            Properties props = repositoryConfig.getProps();
            result.setMaxSleepTimeMilliseconds(RegistryCenterHolder.getProperty(props, "max.sleep.time.milliseconds", result.getMaxSleepTimeMilliseconds()));
            result.setBaseSleepTimeMilliseconds(RegistryCenterHolder.getProperty(props, "base.sleep.time.milliseconds", result.getBaseSleepTimeMilliseconds()));
            result.setConnectionTimeoutMilliseconds(RegistryCenterHolder.getProperty(props, "connection.timeout.milliseconds", result.getConnectionTimeoutMilliseconds()));
            result.setSessionTimeoutMilliseconds(RegistryCenterHolder.getProperty(props, "session.timeout.milliseconds", result.getSessionTimeoutMilliseconds()));
            return result;
        }

        private static int getProperty(Properties props, String key, int defaultValue) {
            return Strings.isNullOrEmpty((String)props.getProperty(key)) ? defaultValue : Integer.parseInt(props.getProperty(key));
        }
    }

    private static final class ElasticJobAPIHolder {
        private static volatile ElasticJobAPIHolder instance;
        private final JobStatisticsAPI jobStatisticsAPI;
        private final JobConfigurationAPI jobConfigurationAPI;
        private final JobOperateAPI jobOperateAPI;

        private ElasticJobAPIHolder() {
            ScalingAPIFactory.checkServerConfig();
            ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)ScalingContext.getInstance().getServerConfig().getModeConfiguration().getRepository();
            String namespace = repositoryConfig.getNamespace() + "/scaling";
            this.jobStatisticsAPI = JobAPIFactory.createJobStatisticsAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
            this.jobConfigurationAPI = JobAPIFactory.createJobConfigurationAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
            this.jobOperateAPI = JobAPIFactory.createJobOperateAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ElasticJobAPIHolder getInstance() {
            if (null != instance) return instance;
            Class<ScalingAPIFactory> clazz = ScalingAPIFactory.class;
            synchronized (ScalingAPIFactory.class) {
                if (null != instance) return instance;
                instance = new ElasticJobAPIHolder();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Generated
        public JobStatisticsAPI getJobStatisticsAPI() {
            return this.jobStatisticsAPI;
        }

        @Generated
        public JobConfigurationAPI getJobConfigurationAPI() {
            return this.jobConfigurationAPI;
        }

        @Generated
        public JobOperateAPI getJobOperateAPI() {
            return this.jobOperateAPI;
        }
    }

    private static final class GovernanceRepositoryAPIHolder {
        private static volatile GovernanceRepositoryAPI instance;

        private GovernanceRepositoryAPIHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static GovernanceRepositoryAPI getInstance() {
            if (null != instance) return instance;
            Class<ScalingAPIFactory> clazz = ScalingAPIFactory.class;
            synchronized (ScalingAPIFactory.class) {
                if (null != instance) return instance;
                instance = GovernanceRepositoryAPIHolder.createGovernanceRepositoryAPI();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static GovernanceRepositoryAPI createGovernanceRepositoryAPI() {
            ScalingAPIFactory.checkServerConfig();
            ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)ScalingContext.getInstance().getServerConfig().getModeConfiguration().getRepository();
            ClusterPersistRepository repository = (ClusterPersistRepository)TypedSPIRegistry.getRegisteredService(ClusterPersistRepository.class, (String)repositoryConfig.getType(), (Properties)repositoryConfig.getProps());
            repository.init(repositoryConfig);
            return new GovernanceRepositoryAPIImpl(repository);
        }

        static {
            ShardingSphereServiceLoader.register(ClusterPersistRepository.class);
        }
    }

    private static final class ScalingAPIHolder {
        private static volatile ScalingAPI instance;

        private ScalingAPIHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ScalingAPI getInstance() {
            if (null != instance) return instance;
            Class<ScalingAPIFactory> clazz = ScalingAPIFactory.class;
            synchronized (ScalingAPIFactory.class) {
                if (null != instance) return instance;
                ScalingAPIFactory.checkServerConfig();
                instance = new ScalingAPIImpl();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }
}

