/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.command.query.binary.bind;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.query.binary.bind.OpenGaussComBatchBindPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.PostgreSQLBindCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;

public final class OpenGaussComBatchBindExecutor
implements QueryCommandExecutor {
    private final OpenGaussComBatchBindPacket packet;
    private final BackendConnection backendConnection;
    private SQLStatement sqlStatement;
    private long updateCount;
    private boolean batchBindComplete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DatabasePacket<?>> execute() throws SQLException {
        this.sqlStatement = this.parseSql(this.packet.getSql(), this.backendConnection.getSchemaName());
        while (this.packet.hasNextParameters()) {
            List parameters = this.packet.readOneGroupOfParameters();
            DatabaseCommunicationEngine databaseCommunicationEngine = this.newEngine(parameters);
            try {
                ResponseHeader responseHeader = databaseCommunicationEngine.execute();
                if (!(responseHeader instanceof UpdateResponseHeader)) continue;
                this.updateCount += ((UpdateResponseHeader)responseHeader).getUpdateCount();
            }
            finally {
                this.backendConnection.closeDatabaseCommunicationEngines(false);
            }
        }
        return Collections.singletonList(new PostgreSQLBindCompletePacket());
    }

    private DatabaseCommunicationEngine newEngine(List<Object> parameter) {
        return DatabaseCommunicationEngineFactory.getInstance().newBinaryProtocolInstance(this.getSqlStatementContext(parameter), this.packet.getSql(), parameter, this.backendConnection);
    }

    private SQLStatementContext<?> getSqlStatementContext(List<Object> parameters) {
        Map metaDataMap = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap();
        return SQLStatementContextFactory.newInstance((Map)metaDataMap, parameters, (SQLStatement)this.sqlStatement, (String)this.backendConnection.getDefaultSchemaName());
    }

    private SQLStatement parseSql(String sql, String schemaName) {
        if (sql.isEmpty()) {
            return new EmptyStatement();
        }
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getResource().getDatabaseType()), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps());
        return sqlStatementParserEngine.parse(sql, true);
    }

    public ResponseType getResponseType() {
        return ResponseType.UPDATE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() {
        if (this.batchBindComplete) return false;
        this.batchBindComplete = true;
        if (!true) return false;
        return true;
    }

    public PostgreSQLPacket getQueryRowPacket() {
        String sqlCommand = PostgreSQLCommand.valueOf(this.sqlStatement.getClass()).map(PostgreSQLCommand::getTag).orElse("");
        return new PostgreSQLCommandCompletePacket(sqlCommand, this.updateCount);
    }

    @Generated
    public OpenGaussComBatchBindExecutor(OpenGaussComBatchBindPacket packet, BackendConnection backendConnection) {
        this.packet = packet;
        this.backendConnection = backendConnection;
    }
}

