/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacketFactory;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacketType;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.OpenGaussCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.opengauss.err.OpenGaussErrorPacketFactory;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContextRegistry;

public final class OpenGaussCommandExecuteEngine
implements CommandExecuteEngine {
    private final PostgreSQLCommandExecuteEngine postgreSQLCommandExecuteEngine = new PostgreSQLCommandExecuteEngine();

    public CommandPacketType getCommandPacketType(PacketPayload payload) {
        return OpenGaussCommandPacketType.valueOf((int)((PostgreSQLPacketPayload)payload).readInt1());
    }

    public CommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, BackendConnection backendConnection) {
        return OpenGaussCommandPacketFactory.newInstance((CommandPacketType)type, (PostgreSQLPacketPayload)((PostgreSQLPacketPayload)payload), (int)backendConnection.getConnectionId());
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, BackendConnection backendConnection) throws SQLException {
        PostgreSQLConnectionContext connectionContext = PostgreSQLConnectionContextRegistry.getInstance().get(backendConnection.getConnectionId());
        return OpenGaussCommandExecutorFactory.newInstance(type, packet, backendConnection, connectionContext);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause, BackendConnection backendConnection) {
        PostgreSQLConnectionContextRegistry.getInstance().get(backendConnection.getConnectionId()).getPendingExecutors().clear();
        return OpenGaussErrorPacketFactory.newInstance(cause);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause) {
        return OpenGaussErrorPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket<?>> getOtherPacket(BackendConnection backendConnection) {
        return this.postgreSQLCommandExecuteEngine.getOtherPacket(backendConnection);
    }

    public boolean writeQueryData(ChannelHandlerContext context, BackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        return this.postgreSQLCommandExecuteEngine.writeQueryData(context, backendConnection, queryCommandExecutor, headerPackagesCount);
    }
}

