/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionEngine;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateEqualRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateInRightValueToken;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.util.DMLStatementContextHelper;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;

public final class EncryptPredicateRightValueTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
SchemaMetaDataAware,
ParametersAware,
QueryWithCipherColumnAware {
    private ShardingSphereSchema schema;
    private List<Object> parameters;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Collection<EncryptCondition> encryptConditions = new EncryptConditionEngine(this.getEncryptRule(), this.schema).createEncryptConditions(sqlStatementContext);
        return encryptConditions.isEmpty() ? Collections.emptyList() : this.generateSQLTokens(DMLStatementContextHelper.getSchemaName((SQLStatementContext)sqlStatementContext), encryptConditions);
    }

    private Collection<SQLToken> generateSQLTokens(String schemaName, Collection<EncryptCondition> encryptConditions) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        for (EncryptCondition each : encryptConditions) {
            result.add(this.generateSQLToken(schemaName, each));
        }
        return result;
    }

    private SQLToken generateSQLToken(String schemaName, EncryptCondition encryptCondition) {
        List<Object> originalValues = encryptCondition.getValues(this.parameters);
        int startIndex = encryptCondition.getStartIndex();
        return this.queryWithCipherColumn ? this.generateSQLTokenForQueryWithCipherColumn(schemaName, encryptCondition, originalValues, startIndex) : this.generateSQLTokenForQueryWithoutCipherColumn(encryptCondition, originalValues, startIndex);
    }

    private SQLToken generateSQLTokenForQueryWithCipherColumn(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), this.getEncryptedValues(schemaName, encryptCondition, originalValues));
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues) {
        Optional<String> assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(encryptCondition.getTableName(), encryptCondition.getColumnName());
        return assistedQueryColumn.isPresent() ? this.getEncryptRule().getEncryptAssistedQueryValues(schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues) : this.getEncryptRule().getEncryptValues(schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues);
    }

    private SQLToken generateSQLTokenForQueryWithoutCipherColumn(EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), originalValues);
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private Map<Integer, Object> getPositionValues(Collection<Integer> valuePositions, List<Object> encryptValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (int each : valuePositions) {
            result.put(each, encryptValues.get(each));
        }
        return result;
    }

    @Generated
    public void setSchema(ShardingSphereSchema schema) {
        this.schema = schema;
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

