/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal;

import org.apache.shardingsphere.encrypt.merge.dal.impl.DecoratedEncryptColumnsMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.impl.MergedEncryptColumnsMergedResult;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowColumnsStatement;

public final class EncryptDALResultDecorator
implements ResultDecorator<EncryptRule> {
    public MergedResult decorate(QueryResult queryResult, SQLStatementContext<?> sqlStatementContext, EncryptRule rule) {
        return this.isNeedMergeEncryptColumns(sqlStatementContext.getSqlStatement()) ? new MergedEncryptColumnsMergedResult(queryResult, sqlStatementContext, rule) : new TransparentMergedResult(queryResult);
    }

    public MergedResult decorate(MergedResult mergedResult, SQLStatementContext<?> sqlStatementContext, EncryptRule rule) {
        return this.isNeedMergeEncryptColumns(sqlStatementContext.getSqlStatement()) ? new DecoratedEncryptColumnsMergedResult(mergedResult, sqlStatementContext, rule) : mergedResult;
    }

    private boolean isNeedMergeEncryptColumns(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLExplainStatement || sqlStatement instanceof MySQLShowColumnsStatement;
    }
}

