/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.converter;

import java.util.Arrays;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;

public enum ShardingStrategyType {
    STANDARD{

        @Override
        public ShardingStrategyConfiguration getConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new StandardShardingStrategyConfiguration(shardingColumn, shardingAlgorithmName);
        }
    }
    ,
    NONE{

        @Override
        public ShardingStrategyConfiguration getConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new NoneShardingStrategyConfiguration();
        }
    }
    ,
    HINT{

        @Override
        public ShardingStrategyConfiguration getConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new HintShardingStrategyConfiguration(shardingAlgorithmName);
        }
    }
    ,
    COMPLEX{

        @Override
        public ShardingStrategyConfiguration getConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new ComplexShardingStrategyConfiguration(shardingColumn, shardingAlgorithmName);
        }
    };


    public abstract ShardingStrategyConfiguration getConfiguration(String var1, String var2);

    public static ShardingStrategyType getValueOf(String name) {
        try {
            return ShardingStrategyType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("unsupported strategy type %s", name));
        }
    }

    public static boolean contain(String name) {
        return Arrays.stream(ShardingStrategyType.values()).map(Enum::name).anyMatch(each -> each.equalsIgnoreCase(name));
    }
}

