/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.initializer;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerInfo;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLServerInfo;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.datasource.DataSourceParameter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.ModeConfigurationYamlSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderFactory;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.config.util.DataSourceParameterConverter;
import org.apache.shardingsphere.proxy.config.yaml.swapper.YamlProxyConfigurationSwapper;
import org.apache.shardingsphere.proxy.database.DatabaseServerInfo;
import org.apache.shardingsphere.scaling.core.api.ScalingWorker;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.config.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BootstrapInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapInitializer.class);

    public void init(YamlProxyConfiguration yamlConfig, int port) throws SQLException {
        ModeConfiguration modeConfig = null == yamlConfig.getServerConfiguration().getMode() ? null : new ModeConfigurationYamlSwapper().swapToObject(yamlConfig.getServerConfiguration().getMode());
        this.initContext(yamlConfig, modeConfig, port);
        this.setDatabaseServerInfo();
        this.initScaling(yamlConfig, modeConfig);
    }

    private void initContext(YamlProxyConfiguration yamlConfig, ModeConfiguration modeConfig, int port) throws SQLException {
        ProxyConfiguration proxyConfig = new YamlProxyConfigurationSwapper().swap(yamlConfig);
        boolean isOverwrite = null == modeConfig || modeConfig.isOverwrite();
        Map<String, Map<String, DataSource>> dataSourcesMap = this.getDataSourcesMap(proxyConfig.getSchemaDataSources());
        ContextManager contextManager = ContextManagerBuilderFactory.newInstance((ModeConfiguration)modeConfig).build(modeConfig, dataSourcesMap, proxyConfig.getSchemaRules(), proxyConfig.getGlobalRules(), proxyConfig.getProps(), isOverwrite, Integer.valueOf(port));
        ProxyContext.getInstance().init(contextManager);
    }

    private Map<String, Map<String, DataSource>> getDataSourcesMap(Map<String, Map<String, DataSourceParameter>> dataSourceParametersMap) {
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(dataSourceParametersMap.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceParameter>> entry : dataSourceParametersMap.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceMap(DataSourceParameterConverter.getDataSourceConfigurationMap(entry.getValue())));
        }
        return result;
    }

    private void setDatabaseServerInfo() {
        this.findBackendDataSource().ifPresent(dataSourceSample -> {
            DatabaseServerInfo databaseServerInfo = new DatabaseServerInfo((DataSource)dataSourceSample);
            log.info(databaseServerInfo.toString());
            switch (databaseServerInfo.getDatabaseName()) {
                case "MySQL": {
                    MySQLServerInfo.setServerVersion((String)databaseServerInfo.getDatabaseVersion());
                    break;
                }
                case "PostgreSQL": {
                    PostgreSQLServerInfo.setServerVersion((String)databaseServerInfo.getDatabaseVersion());
                    break;
                }
            }
        });
    }

    private Optional<DataSource> findBackendDataSource() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional<ShardingSphereMetaData> metaData = metaDataContexts.getMetaDataMap().values().stream().filter(ShardingSphereMetaData::isComplete).findFirst();
        return metaData.flatMap(optional -> optional.getResource().getDataSources().values().stream().findFirst());
    }

    private void initScaling(YamlProxyConfiguration yamlConfig, ModeConfiguration modeConfig) {
        Optional<ServerConfiguration> scalingConfig = this.findScalingConfiguration(yamlConfig);
        if (!scalingConfig.isPresent()) {
            return;
        }
        if (null != modeConfig && "Cluster".equals(modeConfig.getType())) {
            scalingConfig.get().setModeConfiguration(modeConfig);
            ScalingContext.getInstance().init(scalingConfig.get());
            ScalingWorker.init();
        } else {
            ScalingContext.getInstance().init(scalingConfig.get());
        }
    }

    private Optional<ServerConfiguration> findScalingConfiguration(YamlProxyConfiguration yamlConfig) {
        YamlShardingSphereAlgorithmConfiguration dataConsistencyCheckConfig;
        if (null == yamlConfig.getServerConfiguration().getScaling()) {
            return Optional.empty();
        }
        ServerConfiguration result = new ServerConfiguration();
        result.setBlockQueueSize(yamlConfig.getServerConfiguration().getScaling().getBlockQueueSize());
        result.setWorkerThread(yamlConfig.getServerConfiguration().getScaling().getWorkerThread());
        YamlShardingSphereAlgorithmConfiguration autoSwitchConfig = yamlConfig.getServerConfiguration().getScaling().getClusterAutoSwitchAlgorithm();
        if (null != autoSwitchConfig) {
            result.setClusterAutoSwitchAlgorithm(new ShardingSphereAlgorithmConfiguration(autoSwitchConfig.getType(), autoSwitchConfig.getProps()));
        }
        if (null != (dataConsistencyCheckConfig = yamlConfig.getServerConfiguration().getScaling().getDataConsistencyCheckAlgorithm())) {
            result.setDataConsistencyCheckAlgorithm(new ShardingSphereAlgorithmConfiguration(dataConsistencyCheckConfig.getType(), dataConsistencyCheckConfig.getProps()));
        }
        return Optional.of(result);
    }

    @Generated
    public BootstrapInitializer() {
    }
}

