/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;

public final class DatabaseServerInfo {
    private final String databaseName;
    private final String databaseVersion;

    public DatabaseServerInfo(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.databaseName = databaseMetaData.getDatabaseProductName();
            this.databaseVersion = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException ex) {
            throw new ShardingSphereException("Load database server info failed:", (Exception)ex);
        }
    }

    public String toString() {
        return String.format("Database name is `%s`, version is `%s`", this.databaseName, this.databaseVersion);
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getDatabaseVersion() {
        return this.databaseVersion;
    }
}

