/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.config.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceParameter;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.proxy.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.config.util.DataSourceParameterConverter;
import org.apache.shardingsphere.proxy.config.yaml.YamlProxyRuleConfiguration;

public final class YamlProxyConfigurationSwapper {
    public ProxyConfiguration swap(YamlProxyConfiguration yamlConfig) {
        Map<String, Map<String, DataSourceParameter>> schemaDataSources = this.getDataSourceParametersMap(yamlConfig.getRuleConfigurations());
        Map<String, Collection<RuleConfiguration>> schemaRules = this.getRuleConfigurations(yamlConfig.getRuleConfigurations());
        Collection globalRules = new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(yamlConfig.getServerConfiguration().getRules());
        Properties props = yamlConfig.getServerConfiguration().getProps();
        return new ProxyConfiguration(schemaDataSources, schemaRules, globalRules, props);
    }

    private Map<String, Collection<RuleConfiguration>> getRuleConfigurations(Map<String, YamlProxyRuleConfiguration> yamlRuleConfigurations) {
        YamlRuleConfigurationSwapperEngine swapperEngine = new YamlRuleConfigurationSwapperEngine();
        return yamlRuleConfigurations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> swapperEngine.swapToRuleConfigurations(((YamlProxyRuleConfiguration)entry.getValue()).getRules()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, Map<String, DataSourceParameter>> getDataSourceParametersMap(Map<String, YamlProxyRuleConfiguration> yamlRuleConfigurations) {
        return yamlRuleConfigurations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourceParameterConverter.getDataSourceParameterMapFromYamlConfiguration(((YamlProxyRuleConfiguration)entry.getValue()).getDataSources()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }
}

