/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.config.util;

import com.zaxxer.hikari.HikariDataSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceParameter;
import org.apache.shardingsphere.proxy.config.yaml.YamlDataSourceParameter;

public final class DataSourceParameterConverter {
    public static Map<String, DataSourceParameter> getDataSourceParameterMapFromYamlConfiguration(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        return dataSourceParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourceParameterConverter.createDataSourceParameter((YamlDataSourceParameter)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static DataSourceParameter createDataSourceParameter(YamlDataSourceParameter yamlDataSourceParameter) {
        DataSourceParameter result = new DataSourceParameter();
        result.setConnectionTimeoutMilliseconds(yamlDataSourceParameter.getConnectionTimeoutMilliseconds());
        result.setIdleTimeoutMilliseconds(yamlDataSourceParameter.getIdleTimeoutMilliseconds());
        result.setMaxLifetimeMilliseconds(yamlDataSourceParameter.getMaxLifetimeMilliseconds());
        result.setMaxPoolSize(yamlDataSourceParameter.getMaxPoolSize());
        result.setMinPoolSize(yamlDataSourceParameter.getMinPoolSize());
        result.setUsername(yamlDataSourceParameter.getUsername());
        result.setPassword(yamlDataSourceParameter.getPassword());
        result.setReadOnly(yamlDataSourceParameter.isReadOnly());
        result.setUrl(yamlDataSourceParameter.getUrl());
        if (null != yamlDataSourceParameter.getCustomPoolProps()) {
            result.setCustomPoolProps(yamlDataSourceParameter.getCustomPoolProps());
        }
        return result;
    }

    public static Map<String, DataSourceConfiguration> getDataSourceConfigurationMap(Map<String, DataSourceParameter> dataSourceParameterMap) {
        return dataSourceParameterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourceParameterConverter.createDataSourceConfiguration((DataSourceParameter)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static DataSourceConfiguration createDataSourceConfiguration(DataSourceParameter dataSourceParameter) {
        DataSourceConfiguration result = new DataSourceConfiguration(HikariDataSource.class.getName());
        result.getProps().put("jdbcUrl", dataSourceParameter.getUrl());
        result.getProps().put("username", dataSourceParameter.getUsername());
        result.getProps().put("password", dataSourceParameter.getPassword());
        result.getProps().put("connectionTimeout", dataSourceParameter.getConnectionTimeoutMilliseconds());
        result.getProps().put("idleTimeout", dataSourceParameter.getIdleTimeoutMilliseconds());
        result.getProps().put("maxLifetime", dataSourceParameter.getMaxLifetimeMilliseconds());
        result.getProps().put("maximumPoolSize", dataSourceParameter.getMaxPoolSize());
        result.getProps().put("minimumIdle", dataSourceParameter.getMinPoolSize());
        result.getProps().put("readOnly", dataSourceParameter.isReadOnly());
        if (null != dataSourceParameter.getCustomPoolProps()) {
            result.getCustomPoolProps().putAll((Map<?, ?>)dataSourceParameter.getCustomPoolProps());
        }
        return result;
    }

    @Generated
    private DataSourceParameterConverter() {
    }
}

