/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.proxy.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.config.yaml.YamlProxyRuleConfiguration;
import org.apache.shardingsphere.proxy.config.yaml.YamlProxyServerConfiguration;

public final class ProxyConfigurationLoader {
    private static final String SERVER_CONFIG_FILE = "server.yaml";
    private static final Pattern RULE_CONFIG_FILE_PATTERN = Pattern.compile("config-.+\\.yaml");

    public static YamlProxyConfiguration load(String path) throws IOException {
        YamlProxyServerConfiguration serverConfig = ProxyConfigurationLoader.loadServerConfiguration(ProxyConfigurationLoader.getResourceFile(String.join((CharSequence)"/", path, SERVER_CONFIG_FILE)));
        File configPath = ProxyConfigurationLoader.getResourceFile(path);
        Collection<YamlProxyRuleConfiguration> ruleConfigs = ProxyConfigurationLoader.loadRuleConfigurations(configPath);
        return new YamlProxyConfiguration(serverConfig, ruleConfigs.stream().collect(Collectors.toMap(YamlProxyRuleConfiguration::getSchemaName, each -> each, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private static File getResourceFile(String path) {
        URL url = ProxyConfigurationLoader.class.getResource(path);
        return null == url ? new File(path) : new File(url.getFile());
    }

    private static YamlProxyServerConfiguration loadServerConfiguration(File yamlFile) throws IOException {
        YamlProxyServerConfiguration result = (YamlProxyServerConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyServerConfiguration.class);
        Preconditions.checkNotNull((Object)result, (String)"Server configuration file `%s` is invalid.", (Object)yamlFile.getName());
        boolean containsGovernance = null != result.getMode() && "Cluster".equals(result.getMode().getType());
        YamlRuleConfiguration authorityRuleConfig = result.getRules().stream().filter(ruleConfig -> ruleConfig instanceof YamlAuthorityRuleConfiguration).findAny().orElse(null);
        Preconditions.checkState((containsGovernance || null != authorityRuleConfig ? 1 : 0) != 0, (Object)"Authority configuration is invalid.");
        return result;
    }

    private static Collection<YamlProxyRuleConfiguration> loadRuleConfigurations(File configPath) throws IOException {
        HashSet loadedSchemaNames = new HashSet();
        LinkedList<YamlProxyRuleConfiguration> result = new LinkedList<YamlProxyRuleConfiguration>();
        for (File each : ProxyConfigurationLoader.findRuleConfigurationFiles(configPath)) {
            ProxyConfigurationLoader.loadRuleConfiguration(each).ifPresent(yamlProxyRuleConfig -> {
                Preconditions.checkState((boolean)loadedSchemaNames.add(yamlProxyRuleConfig.getSchemaName()), (String)"Schema name `%s` must unique at all rule configurations.", (Object)yamlProxyRuleConfig.getSchemaName());
                result.add((YamlProxyRuleConfiguration)yamlProxyRuleConfig);
            });
        }
        return result;
    }

    private static Optional<YamlProxyRuleConfiguration> loadRuleConfiguration(File yamlFile) throws IOException {
        YamlProxyRuleConfiguration result = (YamlProxyRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyRuleConfiguration.class);
        if (null == result) {
            return Optional.empty();
        }
        Preconditions.checkNotNull((Object)result.getSchemaName(), (String)"Property `schemaName` in file `%s` is required.", (Object)yamlFile.getName());
        Preconditions.checkState((!result.getDataSources().isEmpty() ? 1 : 0) != 0, (String)"Data sources configuration in file `%s` is required.", (Object)yamlFile.getName());
        return Optional.of(result);
    }

    private static File[] findRuleConfigurationFiles(File path) {
        return path.listFiles(each -> RULE_CONFIG_FILE_PATTERN.matcher(each.getName()).matches());
    }

    @Generated
    private ProxyConfigurationLoader() {
    }
}

