/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.arguments;

import lombok.Generated;

public final class BootstrapArguments {
    private static final String DEFAULT_CONFIG_PATH = "/conf/";
    private static final int DEFAULT_PORT = 3307;
    private final int port;
    private final String configurationPath;

    public BootstrapArguments(String[] args) {
        this.port = this.getPort(args);
        this.configurationPath = this.getConfigurationPath(args);
    }

    private int getPort(String[] args) {
        if (0 == args.length) {
            return 3307;
        }
        try {
            return Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Invalid port `%s`.", args[0]));
        }
    }

    private String getConfigurationPath(String[] args) {
        return args.length < 2 ? DEFAULT_CONFIG_PATH : this.paddingWithSlash(args[1]);
    }

    private String paddingWithSlash(String arg) {
        StringBuilder result = new StringBuilder(arg);
        if (!arg.startsWith("/")) {
            result.insert(0, '/');
        }
        if (!arg.endsWith("/")) {
            result.append('/');
        }
        return result.toString();
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getConfigurationPath() {
        return this.configurationPath;
    }
}

