/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.err;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.error.CommonErrorCode;
import org.apache.shardingsphere.db.protocol.error.SQLErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.exception.SchemaNotExistedException;
import org.apache.shardingsphere.proxy.backend.exception.CircuitBreakException;
import org.apache.shardingsphere.proxy.backend.exception.DBCreateExistsException;
import org.apache.shardingsphere.proxy.backend.exception.DBDropExistsException;
import org.apache.shardingsphere.proxy.backend.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.exception.TableLockWaitTimeoutException;
import org.apache.shardingsphere.proxy.backend.exception.TableLockedException;
import org.apache.shardingsphere.proxy.backend.exception.TableModifyInTransactionException;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.CommonDistSQLErrorCode;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.CommonDistSQLException;
import org.apache.shardingsphere.proxy.frontend.exception.FrontendTooManyConnectionsException;
import org.apache.shardingsphere.proxy.frontend.exception.UnsupportedCommandException;
import org.apache.shardingsphere.proxy.frontend.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingJobNotFoundException;
import org.apache.shardingsphere.sharding.route.engine.exception.NoSuchTableException;
import org.apache.shardingsphere.sharding.route.engine.exception.TableExistsException;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class MySQLErrPacketFactory {
    public static MySQLErrPacket newInstance(Exception cause) {
        if (cause instanceof SQLException) {
            SQLException sqlException = (SQLException)cause;
            return null == sqlException.getSQLState() ? new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_INTERNAL_ERROR, new Object[]{cause.getMessage()}) : new MySQLErrPacket(1, sqlException.getErrorCode(), sqlException.getSQLState(), sqlException.getMessage());
        }
        if (cause instanceof CommonDistSQLException) {
            CommonDistSQLException commonDistSQLException = (CommonDistSQLException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonDistSQLErrorCode.valueOf((CommonDistSQLException)commonDistSQLException), new Object[]{commonDistSQLException.getVariable()});
        }
        if (cause instanceof TableModifyInTransactionException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE, new Object[]{((TableModifyInTransactionException)cause).getTableName()});
        }
        if (cause instanceof UnknownDatabaseException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_BAD_DB_ERROR, new Object[]{((UnknownDatabaseException)cause).getDatabaseName()});
        }
        if (cause instanceof NoDatabaseSelectedException || cause instanceof SchemaNotExistedException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NO_DB_ERROR, new Object[0]);
        }
        if (cause instanceof DBCreateExistsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_DB_CREATE_EXISTS_ERROR, new Object[]{((DBCreateExistsException)cause).getDatabaseName()});
        }
        if (cause instanceof DBDropExistsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_DB_DROP_EXISTS_ERROR, new Object[]{((DBDropExistsException)cause).getDatabaseName()});
        }
        if (cause instanceof TableExistsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_TABLE_EXISTS_ERROR, new Object[]{((TableExistsException)cause).getTableName()});
        }
        if (cause instanceof NoSuchTableException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NO_SUCH_TABLE, new Object[]{((NoSuchTableException)cause).getTableName()});
        }
        if (cause instanceof CircuitBreakException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.CIRCUIT_BREAK_MODE, new Object[0]);
        }
        if (cause instanceof UnsupportedCommandException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.UNSUPPORTED_COMMAND, new Object[]{((UnsupportedCommandException)cause).getCommandType()});
        }
        if (cause instanceof UnsupportedPreparedStatementException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_UNSUPPORTED_PS, new Object[0]);
        }
        if (cause instanceof ShardingSphereConfigurationException || cause instanceof SQLParsingException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NOT_SUPPORTED_YET, new Object[]{cause.getMessage()});
        }
        if (cause instanceof RuleNotExistedException || cause instanceof DatabaseNotExistedException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_SP_DOES_NOT_EXIST, new Object[0]);
        }
        if (cause instanceof TableLockWaitTimeoutException) {
            TableLockWaitTimeoutException exception = (TableLockWaitTimeoutException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.TABLE_LOCK_WAIT_TIMEOUT, new Object[]{exception.getTableName(), exception.getSchemaName(), exception.getTimeoutMilliseconds()});
        }
        if (cause instanceof TableLockedException) {
            TableLockedException exception = (TableLockedException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.TABLE_LOCKED, new Object[]{exception.getTableName(), exception.getSchemaName()});
        }
        if (cause instanceof ScalingJobNotFoundException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.SCALING_JOB_NOT_EXIST, new Object[]{((ScalingJobNotFoundException)cause).getJobId()});
        }
        if (cause instanceof FrontendTooManyConnectionsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.TOO_MANY_CONNECTIONS_EXCEPTION, new Object[]{CommonErrorCode.TOO_MANY_CONNECTIONS_EXCEPTION.getErrorMessage()});
        }
        if (cause instanceof RuntimeException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.RUNTIME_EXCEPTION, new Object[]{cause.getMessage()});
        }
        return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.UNKNOWN_EXCEPTION, new Object[]{cause.getMessage()});
    }

    @Generated
    private MySQLErrPacketFactory() {
    }
}

