/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query;

import java.sql.SQLException;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.MySQLTextResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;

public final class MySQLComQueryPacketExecutor
implements QueryCommandExecutor {
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private final int characterSet;
    private volatile ResponseType responseType;
    private int currentSequenceId;

    public MySQLComQueryPacketExecutor(MySQLComQueryPacket packet, BackendConnection backendConnection) throws SQLException {
        this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeRegistry.getActualDatabaseType((String)"MySQL"), (String)packet.getSql(), (BackendConnection)backendConnection);
        this.characterSet = ((MySQLCharacterSet)backendConnection.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        ResponseHeader responseHeader = this.textProtocolBackendHandler.execute();
        return responseHeader instanceof QueryResponseHeader ? this.processQuery((QueryResponseHeader)responseHeader) : this.processUpdate((UpdateResponseHeader)responseHeader);
    }

    private Collection<DatabasePacket<?>> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        Collection<DatabasePacket<?>> result = ResponsePacketBuilder.buildQueryResponsePackets(queryResponseHeader, this.characterSet);
        this.currentSequenceId = result.size();
        return result;
    }

    private Collection<DatabasePacket<?>> processUpdate(UpdateResponseHeader updateResponseHeader) {
        this.responseType = ResponseType.UPDATE;
        return ResponsePacketBuilder.buildUpdateResponsePackets(updateResponseHeader);
    }

    public boolean next() throws SQLException {
        return this.textProtocolBackendHandler.next();
    }

    public MySQLPacket getQueryRowPacket() throws SQLException {
        return new MySQLTextResultSetRowPacket(++this.currentSequenceId, this.textProtocolBackendHandler.getRowData());
    }

    public void close() throws SQLException {
        this.textProtocolBackendHandler.close();
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

