/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLBinaryStatementRegistry;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPrepareOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPreparePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare.MySQLComStmtPrepareChecker;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class MySQLComStmtPrepareExecutor
implements CommandExecutor {
    private static final MySQLBinaryStatementRegistry PREPARED_STATEMENT_REGISTRY = MySQLBinaryStatementRegistry.getInstance();
    private final MySQLComStmtPreparePacket packet;
    private final BackendConnection backendConnection;
    private final int characterSet;
    private int currentSequenceId;

    public MySQLComStmtPrepareExecutor(MySQLComStmtPreparePacket packet, BackendConnection backendConnection) {
        this.packet = packet;
        this.backendConnection = backendConnection;
        this.characterSet = ((MySQLCharacterSet)backendConnection.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    public Collection<DatabasePacket<?>> execute() {
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(this.backendConnection.getSchemaName()).getResource().getDatabaseType()), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps());
        SQLStatement sqlStatement = sqlStatementParserEngine.parse(this.packet.getSql(), true);
        if (!MySQLComStmtPrepareChecker.isStatementAllowed(sqlStatement)) {
            throw new UnsupportedPreparedStatementException();
        }
        int parameterCount = sqlStatement.getParameterCount();
        int projectionCount = this.getProjectionCount(sqlStatement);
        int statementId = PREPARED_STATEMENT_REGISTRY.register(this.packet.getSql(), parameterCount);
        return this.createPackets(statementId, projectionCount, parameterCount);
    }

    private int getProjectionCount(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            Map metaDataMap = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap();
            String schemaName = this.backendConnection.getSchemaName();
            SelectStatementContext sqlStatementContext = (SelectStatementContext)SQLStatementContextFactory.newInstance((Map)metaDataMap, Collections.emptyList(), (SQLStatement)sqlStatement, (String)schemaName);
            return sqlStatementContext.getProjectionsContext().getExpandProjections().size();
        }
        return 0;
    }

    private Collection<DatabasePacket<?>> createPackets(int statementId, int projectionCount, int parameterCount) {
        LinkedList result = new LinkedList();
        result.add((DatabasePacket<?>)new MySQLComStmtPrepareOKPacket(++this.currentSequenceId, statementId, projectionCount, parameterCount, 0));
        if (parameterCount > 0) {
            result.addAll(this.createParameterColumnDefinition41Packets(parameterCount));
        }
        if (projectionCount > 0) {
            result.addAll(this.createProjectionColumnDefinition41Packets(projectionCount));
        }
        return result;
    }

    private Collection<DatabasePacket<?>> createParameterColumnDefinition41Packets(int parameterCount) {
        LinkedList result = new LinkedList();
        for (int i = 0; i < parameterCount; ++i) {
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++this.currentSequenceId, this.characterSet, "", "", "", "?", "", 0, MySQLBinaryColumnType.MYSQL_TYPE_VAR_STRING, 0, false));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
        return result;
    }

    private Collection<DatabasePacket<?>> createProjectionColumnDefinition41Packets(int projectionCount) {
        LinkedList result = new LinkedList();
        for (int i = 0; i < projectionCount; ++i) {
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++this.currentSequenceId, this.characterSet, "", "", "", "", "", 0, MySQLBinaryColumnType.MYSQL_TYPE_VAR_STRING, 0, false));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
        return result;
    }
}

