/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.execute;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.binary.BinaryRow;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLBinaryResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLComStmtExecutePacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementSchemaHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.BinaryQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class MySQLComStmtExecuteExecutor
implements QueryCommandExecutor {
    private final DatabaseCommunicationEngine databaseCommunicationEngine;
    private final int characterSet;
    private volatile ResponseType responseType;
    private int currentSequenceId;

    public MySQLComStmtExecuteExecutor(MySQLComStmtExecutePacket packet, BackendConnection backendConnection) {
        String schemaName = backendConnection.getSchemaName();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(schemaName).getResource().getDatabaseType()), metaDataContexts.getProps());
        SQLStatement sqlStatement = sqlStatementParserEngine.parse(packet.getSql(), true);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaDataMap(), (List)packet.getParameters(), (SQLStatement)sqlStatement, (String)backendConnection.getDefaultSchemaName());
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().ifPresent(SQLStatementSchemaHolder::set);
        }
        SQLCheckEngine.check((SQLStatement)sqlStatement, Collections.emptyList(), MySQLComStmtExecuteExecutor.getRules(schemaName), (String)schemaName, (Map)metaDataContexts.getMetaDataMap(), (Grantee)backendConnection.getGrantee());
        this.databaseCommunicationEngine = DatabaseCommunicationEngineFactory.getInstance().newBinaryProtocolInstance(sqlStatementContext, packet.getSql(), packet.getParameters(), backendConnection);
        this.characterSet = ((MySQLCharacterSet)backendConnection.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    private static Collection<ShardingSphereRule> getRules(String schemaName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules());
        return result;
    }

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        ResponseHeader responseHeader = this.databaseCommunicationEngine.execute();
        return responseHeader instanceof QueryResponseHeader ? this.processQuery((QueryResponseHeader)responseHeader) : this.processUpdate((UpdateResponseHeader)responseHeader);
    }

    private Collection<DatabasePacket<?>> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        Collection<DatabasePacket<?>> result = ResponsePacketBuilder.buildQueryResponsePackets(queryResponseHeader, this.characterSet);
        this.currentSequenceId = result.size();
        return result;
    }

    private Collection<DatabasePacket<?>> processUpdate(UpdateResponseHeader updateResponseHeader) {
        this.responseType = ResponseType.UPDATE;
        return ResponsePacketBuilder.buildUpdateResponsePackets(updateResponseHeader);
    }

    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    public MySQLPacket getQueryRowPacket() throws SQLException {
        QueryResponseRow queryResponseRow = this.databaseCommunicationEngine.getQueryResponseRow();
        return new MySQLBinaryResultSetRowPacket(++this.currentSequenceId, this.createBinaryRow(queryResponseRow));
    }

    private BinaryRow createBinaryRow(QueryResponseRow queryResponseRow) {
        return new BinaryRow((Collection)queryResponseRow.getCells().stream().map(each -> new BinaryCell((BinaryColumnType)MySQLBinaryColumnType.valueOfJDBCType((int)((BinaryQueryResponseCell)each).getJdbcType()), each.getData())).collect(Collectors.toList()));
    }

    public void close() throws SQLException {
        this.databaseCommunicationEngine.close();
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

