/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.initdb.MySQLComInitDbPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.close.MySQLComStmtClosePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLComStmtExecutePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPreparePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.reset.MySQLComStmtResetPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.fieldlist.MySQLComFieldListPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.admin.initdb.MySQLComInitDbExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.admin.ping.MySQLComPingExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.admin.quit.MySQLComQuitExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.generic.MySQLUnsupportedCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.close.MySQLComStmtCloseExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.execute.MySQLComStmtExecuteExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare.MySQLComStmtPrepareExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.reset.MySQLComStmtResetExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.fieldlist.MySQLComFieldListPacketExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query.MySQLComQueryPacketExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLCommandExecutorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLCommandExecutorFactory.class);

    public static CommandExecutor newInstance(MySQLCommandPacketType commandPacketType, CommandPacket commandPacket, BackendConnection backendConnection) throws SQLException {
        log.debug("Execute packet type: {}, value: {}", (Object)commandPacketType, (Object)commandPacket);
        switch (commandPacketType) {
            case COM_QUIT: {
                return new MySQLComQuitExecutor();
            }
            case COM_INIT_DB: {
                return new MySQLComInitDbExecutor((MySQLComInitDbPacket)commandPacket, backendConnection);
            }
            case COM_FIELD_LIST: {
                return new MySQLComFieldListPacketExecutor((MySQLComFieldListPacket)commandPacket, backendConnection);
            }
            case COM_QUERY: {
                return new MySQLComQueryPacketExecutor((MySQLComQueryPacket)commandPacket, backendConnection);
            }
            case COM_PING: {
                return new MySQLComPingExecutor();
            }
            case COM_STMT_PREPARE: {
                return new MySQLComStmtPrepareExecutor((MySQLComStmtPreparePacket)commandPacket, backendConnection);
            }
            case COM_STMT_EXECUTE: {
                return new MySQLComStmtExecuteExecutor((MySQLComStmtExecutePacket)commandPacket, backendConnection);
            }
            case COM_STMT_RESET: {
                return new MySQLComStmtResetExecutor((MySQLComStmtResetPacket)commandPacket);
            }
            case COM_STMT_CLOSE: {
                return new MySQLComStmtCloseExecutor((MySQLComStmtClosePacket)commandPacket);
            }
        }
        return new MySQLUnsupportedCommandExecutor(commandPacketType);
    }

    @Generated
    private MySQLCommandExecutorFactory() {
    }
}

