/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketFactory;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketTypeLoader;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.MySQLCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.mysql.err.MySQLErrPacketFactory;

public final class MySQLCommandExecuteEngine
implements CommandExecuteEngine {
    public MySQLCommandPacketType getCommandPacketType(PacketPayload payload) {
        return MySQLCommandPacketTypeLoader.getCommandPacketType((MySQLPacketPayload)((MySQLPacketPayload)payload));
    }

    public MySQLCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, BackendConnection backendConnection) throws SQLException {
        return MySQLCommandPacketFactory.newInstance((MySQLCommandPacketType)((MySQLCommandPacketType)type), (MySQLPacketPayload)((MySQLPacketPayload)payload));
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, BackendConnection backendConnection) throws SQLException {
        return MySQLCommandExecutorFactory.newInstance((MySQLCommandPacketType)type, packet, backendConnection);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause, BackendConnection backendConnection) {
        return MySQLErrPacketFactory.newInstance(cause);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause) {
        return MySQLErrPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket<?>> getOtherPacket(BackendConnection backendConnection) {
        return Optional.empty();
    }

    public boolean writeQueryData(ChannelHandlerContext context, BackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (ResponseType.QUERY != queryCommandExecutor.getResponseType() || !context.channel().isActive()) {
            return true;
        }
        int count = 0;
        int flushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        int currentSequenceId = 0;
        while (queryCommandExecutor.next()) {
            ++count;
            while (!context.channel().isWritable() && context.channel().isActive()) {
                context.flush();
                backendConnection.getResourceLock().doAwait();
            }
            DatabasePacket dataValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)dataValue);
            if (flushThreshold == count) {
                context.flush();
                count = 0;
            }
            ++currentSequenceId;
        }
        context.write((Object)new MySQLEofPacket(++currentSequenceId + headerPackagesCount));
        return true;
    }
}

