/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.authentication;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthPluginData;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class MySQLAuthenticationHandler {
    private static final ProxyContext PROXY_SCHEMA_CONTEXTS = ProxyContext.getInstance();
    private final MySQLAuthPluginData authPluginData = new MySQLAuthPluginData();

    public Optional<MySQLServerErrorCode> login(String username, String hostname, byte[] authenticationResponse, String databaseName) {
        Grantee grantee = new Grantee(username, hostname);
        Collection rules = ProxyContext.getInstance().getRules(databaseName);
        if (!SQLCheckEngine.check((Grantee)grantee, (a, b) -> this.isPasswordRight((ShardingSphereUser)a, (byte[])b), (Object)authenticationResponse, (Collection)rules)) {
            return Optional.of(MySQLServerErrorCode.ER_ACCESS_DENIED_ERROR);
        }
        return null == databaseName || SQLCheckEngine.check((String)databaseName, (Collection)rules, (Grantee)grantee) ? Optional.empty() : Optional.of(MySQLServerErrorCode.ER_DBACCESS_DENIED_ERROR);
    }

    private boolean isPasswordRight(ShardingSphereUser user, byte[] authentication) {
        return Strings.isNullOrEmpty((String)user.getPassword()) || Arrays.equals(this.getAuthCipherBytes(user.getPassword()), authentication);
    }

    private byte[] getAuthCipherBytes(String password) {
        byte[] sha1Password = DigestUtils.sha1((String)password);
        byte[] doubleSha1Password = DigestUtils.sha1((byte[])sha1Password);
        byte[] concatBytes = new byte[this.authPluginData.getAuthenticationPluginData().length + doubleSha1Password.length];
        System.arraycopy(this.authPluginData.getAuthenticationPluginData(), 0, concatBytes, 0, this.authPluginData.getAuthenticationPluginData().length);
        System.arraycopy(doubleSha1Password, 0, concatBytes, this.authPluginData.getAuthenticationPluginData().length, doubleSha1Password.length);
        byte[] sha1ConcatBytes = DigestUtils.sha1((byte[])concatBytes);
        return this.xor(sha1Password, sha1ConcatBytes);
    }

    private byte[] xor(byte[] input, byte[] secret) {
        byte[] result = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = (byte)(input[i] ^ secret[i]);
        }
        return result;
    }

    @Generated
    public MySQLAuthPluginData getAuthPluginData() {
        return this.authPluginData;
    }
}

