/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.parser.core;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.ShardingDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ShardingDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.BindingTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.KeyGenerateSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingAlgorithmSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.TableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingBindingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingAlgorithmStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingBindingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingAlgorithmStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBindingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingAlgorithmsStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingBindingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.AddShardingHintDatabaseValueStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.AddShardingHintTableValueStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.ClearShardingHintStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.SetShardingHintDatabaseValueStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.ShowShardingHintStatusStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ShardingDistSQLStatementVisitor
extends ShardingDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateShardingTableRule(ShardingDistSQLStatementParser.CreateShardingTableRuleContext ctx) {
        List tableRuleSegments = ctx.shardingTableRuleDefinition().stream().map(each -> (AbstractTableRuleSegment)this.visit((ParseTree)each)).filter(Objects::nonNull).collect(Collectors.toList());
        if (tableRuleSegments.isEmpty()) {
            return new AbstractTableRuleSegment.EmptyTableRuleSegment();
        }
        return new CreateShardingTableRuleStatement(tableRuleSegments);
    }

    @Override
    public ASTNode visitCreateShardingBindingTableRules(ShardingDistSQLStatementParser.CreateShardingBindingTableRulesContext ctx) {
        return new CreateShardingBindingTableRulesStatement(this.createBindingTableRuleSegment(ctx.bindTableRulesDefinition()));
    }

    private Collection<BindingTableRuleSegment> createBindingTableRuleSegment(List<ShardingDistSQLStatementParser.BindTableRulesDefinitionContext> contexts) {
        return contexts.stream().map(each -> Joiner.on((String)",").join((Iterable)each.tableName().stream().map(t -> this.getIdentifierValue((ParseTree)t)).collect(Collectors.toList()))).map(BindingTableRuleSegment::new).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public ASTNode visitCreateShardingBroadcastTableRules(ShardingDistSQLStatementParser.CreateShardingBroadcastTableRulesContext ctx) {
        return new CreateShardingBroadcastTableRulesStatement((Collection)ctx.tableName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterShardingTableRule(ShardingDistSQLStatementParser.AlterShardingTableRuleContext ctx) {
        List tableRuleSegments = ctx.shardingTableRuleDefinition().stream().map(each -> (AbstractTableRuleSegment)this.visit((ParseTree)each)).filter(Objects::nonNull).collect(Collectors.toList());
        if (tableRuleSegments.isEmpty()) {
            return new AbstractTableRuleSegment.EmptyTableRuleSegment();
        }
        return new AlterShardingTableRuleStatement(tableRuleSegments);
    }

    @Override
    public ASTNode visitShowShardingBroadcastTableRules(ShardingDistSQLStatementParser.ShowShardingBroadcastTableRulesContext ctx) {
        return new ShowShardingBroadcastTableRulesStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitAlterShardingBindingTableRules(ShardingDistSQLStatementParser.AlterShardingBindingTableRulesContext ctx) {
        LinkedList<BindingTableRuleSegment> rules = new LinkedList<BindingTableRuleSegment>();
        for (ShardingDistSQLStatementParser.BindTableRulesDefinitionContext each : ctx.bindTableRulesDefinition()) {
            rules.add(new BindingTableRuleSegment(Joiner.on((String)",").join((Iterable)each.tableName().stream().map(t -> new IdentifierValue(t.getText()).getValue()).collect(Collectors.toList()))));
        }
        return new AlterShardingBindingTableRulesStatement(rules);
    }

    @Override
    public ASTNode visitAlterShardingBroadcastTableRules(ShardingDistSQLStatementParser.AlterShardingBroadcastTableRulesContext ctx) {
        return new AlterShardingBroadcastTableRulesStatement((Collection)ctx.tableName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShardingTableRule(ShardingDistSQLStatementParser.DropShardingTableRuleContext ctx) {
        return new DropShardingTableRuleStatement((Collection)ctx.tableName().stream().map(each -> (TableNameSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShardingBindingTableRules(ShardingDistSQLStatementParser.DropShardingBindingTableRulesContext ctx) {
        List tableNames = null == ctx.bindTableRulesDefinition() ? Collections.emptyList() : this.createBindingTableRuleSegment(ctx.bindTableRulesDefinition());
        return new DropShardingBindingTableRulesStatement(tableNames);
    }

    @Override
    public ASTNode visitCreateDefaultShardingStrategy(ShardingDistSQLStatementParser.CreateDefaultShardingStrategyContext ctx) {
        ShardingDistSQLStatementParser.ShardingStrategyContext shardingStrategyContext = ctx.shardingStrategy();
        return new CreateDefaultShardingStrategyStatement(new IdentifierValue(ctx.type.getText()).getValue().toLowerCase(), this.getIdentifierValue((ParseTree)shardingStrategyContext.strategyType()).toLowerCase(), this.getIdentifierValue((ParseTree)shardingStrategyContext.shardingColumn().columnName()).toLowerCase(), this.getIdentifierValue((ParseTree)shardingStrategyContext.shardingAlgorithm().shardingAlgorithmName()).toLowerCase());
    }

    @Override
    public ASTNode visitSetShardingHintDatabaseValue(ShardingDistSQLStatementParser.SetShardingHintDatabaseValueContext ctx) {
        return new SetShardingHintDatabaseValueStatement(this.getIdentifierValue((ParseTree)ctx.shardingValue()));
    }

    @Override
    public ASTNode visitAddShardingHintDatabaseValue(ShardingDistSQLStatementParser.AddShardingHintDatabaseValueContext ctx) {
        return new AddShardingHintDatabaseValueStatement(this.getIdentifierValue((ParseTree)ctx.tableName()), this.getIdentifierValue((ParseTree)ctx.shardingValue()));
    }

    @Override
    public ASTNode visitAddShardingHintTableValue(ShardingDistSQLStatementParser.AddShardingHintTableValueContext ctx) {
        return new AddShardingHintTableValueStatement(this.getIdentifierValue((ParseTree)ctx.tableName()), this.getIdentifierValue((ParseTree)ctx.shardingValue()));
    }

    @Override
    public ASTNode visitShowShardingHintStatus(ShardingDistSQLStatementParser.ShowShardingHintStatusContext ctx) {
        return new ShowShardingHintStatusStatement();
    }

    @Override
    public ASTNode visitClearShardingHint(ShardingDistSQLStatementParser.ClearShardingHintContext ctx) {
        return new ClearShardingHintStatement();
    }

    @Override
    public ASTNode visitDropShardingBroadcastTableRules(ShardingDistSQLStatementParser.DropShardingBroadcastTableRulesContext ctx) {
        List tableNames = ctx.tableName() == null ? Collections.emptyList() : (Collection)ctx.tableName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toCollection(LinkedList::new));
        return new DropShardingBroadcastTableRulesStatement(tableNames);
    }

    @Override
    public ASTNode visitDropShardingAlgorithm(ShardingDistSQLStatementParser.DropShardingAlgorithmContext ctx) {
        return new DropShardingAlgorithmStatement((Collection)ctx.algorithmName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowShardingTableRules(ShardingDistSQLStatementParser.ShowShardingTableRulesContext ctx) {
        return new ShowShardingTableRulesStatement(null == ctx.tableRule() ? null : this.getIdentifierValue((ParseTree)ctx.tableRule().tableName()), null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowShardingAlgorithms(ShardingDistSQLStatementParser.ShowShardingAlgorithmsContext ctx) {
        return new ShowShardingAlgorithmsStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitShardingTableRuleDefinition(ShardingDistSQLStatementParser.ShardingTableRuleDefinitionContext ctx) {
        if (null != ctx.shardingTableRule()) {
            return (ASTNode)this.visit((ParseTree)ctx.shardingTableRule());
        }
        if (null != ctx.shardingAutoTableRule()) {
            return (ASTNode)this.visit((ParseTree)ctx.shardingAutoTableRule());
        }
        return null;
    }

    @Override
    public ASTNode visitShardingTableRule(ShardingDistSQLStatementParser.ShardingTableRuleContext ctx) {
        String tableName = this.getIdentifierValue((ParseTree)ctx.tableName());
        Collection<String> dataNodes = this.getDataNodes(ctx.dataNodes());
        ShardingStrategySegment tableStrategy = (ShardingStrategySegment)this.visit((ParseTree)ctx.tableStrategy().shardingStrategy());
        ShardingStrategySegment databaseStrategy = (ShardingStrategySegment)this.visit((ParseTree)ctx.databaseStrategy().shardingStrategy());
        KeyGenerateSegment keyGenerateSegment = (KeyGenerateSegment)this.visit((ParseTree)ctx.keyGenerateStrategy());
        return new TableRuleSegment(tableName, dataNodes, databaseStrategy, tableStrategy, keyGenerateSegment);
    }

    @Override
    public ASTNode visitShardingAutoTableRule(ShardingDistSQLStatementParser.ShardingAutoTableRuleContext ctx) {
        String tableName = this.getIdentifierValue((ParseTree)ctx.tableName());
        Collection<String> dataSources = this.getResources(ctx.resources());
        AutoTableRuleSegment result = new AutoTableRuleSegment(tableName, dataSources);
        Optional.ofNullable(ctx.keyGenerateStrategy()).ifPresent(op -> result.setKeyGenerateSegment((KeyGenerateSegment)this.visit((ParseTree)ctx.keyGenerateStrategy())));
        Optional.ofNullable(ctx.shardingColumn()).ifPresent(op -> result.setShardingColumn(this.getIdentifierValue((ParseTree)ctx.shardingColumn().columnName())));
        Optional.ofNullable(ctx.algorithmDefinition()).ifPresent(op -> result.setShardingAlgorithmSegment((AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition())));
        return result;
    }

    @Override
    public ASTNode visitKeyGenerateStrategy(ShardingDistSQLStatementParser.KeyGenerateStrategyContext ctx) {
        if (ctx == null) {
            return null;
        }
        return new KeyGenerateSegment(this.getIdentifierValue((ParseTree)ctx.columnName()), (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitShardingStrategy(ShardingDistSQLStatementParser.ShardingStrategyContext ctx) {
        if (ctx == null) {
            return null;
        }
        return new ShardingStrategySegment(this.getIdentifierValue((ParseTree)ctx.strategyType()), this.getIdentifierValue((ParseTree)ctx.shardingColumn().columnName()), this.getIdentifierValue((ParseTree)ctx.shardingAlgorithm().shardingAlgorithmName()));
    }

    private Collection<String> getResources(ShardingDistSQLStatementParser.ResourcesContext ctx) {
        return ctx.resource().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toCollection(LinkedList::new));
    }

    private Collection<String> getDataNodes(ShardingDistSQLStatementParser.DataNodesContext ctx) {
        return ctx.dataNode().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ShardingDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmName()), this.getAlgorithmProperties(ctx));
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    private Properties getAlgorithmProperties(ShardingDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx.algorithmProperties()) {
            return result;
        }
        for (ShardingDistSQLStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperties().algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitCreateShardingAlgorithm(ShardingDistSQLStatementParser.CreateShardingAlgorithmContext ctx) {
        return new CreateShardingAlgorithmStatement((Collection)ctx.shardingAlgorithmDefinition().stream().map(this::buildAlgorithmSegment).collect(Collectors.toCollection(LinkedList::new)));
    }

    private ShardingAlgorithmSegment buildAlgorithmSegment(ShardingDistSQLStatementParser.ShardingAlgorithmDefinitionContext ctx) {
        return new ShardingAlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.shardingAlgorithmName()), (AlgorithmSegment)this.visitAlgorithmDefinition(ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitTableName(ShardingDistSQLStatementParser.TableNameContext ctx) {
        return new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitShowShardingBindingTableRules(ShardingDistSQLStatementParser.ShowShardingBindingTableRulesContext ctx) {
        return new ShowShardingBindingTableRulesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitSchemaName(ShardingDistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }
}

