/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service;

import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class LockNode {
    private static final String LOCK_NODE_ROOT = "lock";
    private static final String LOCKS_NODE = "locks";
    private static final String LOCKED_ACK_NODE = "ack";

    public static String getLockRootNodePath() {
        return Joiner.on((String)"/").join((Object)"", (Object)LOCK_NODE_ROOT, new Object[]{LOCKS_NODE});
    }

    public static String getLockNodePath(String lockName) {
        return Joiner.on((String)"/").join((Object)"", (Object)LOCK_NODE_ROOT, new Object[]{LOCKS_NODE, lockName});
    }

    public static String getLockedAckRootNodePah() {
        return Joiner.on((String)"/").join((Object)"", (Object)LOCK_NODE_ROOT, new Object[]{LOCKED_ACK_NODE});
    }

    public static String getLockedAckNodePath(String ackLockName) {
        return Joiner.on((String)"/").join((Object)"", (Object)LOCK_NODE_ROOT, new Object[]{LOCKED_ACK_NODE, ackLockName});
    }

    public static Optional<String> getLockName(String lockNodePath) {
        Pattern pattern = Pattern.compile(LockNode.getLockRootNodePath() + "/(.+)/(.+)$", 2);
        Matcher matcher = pattern.matcher(lockNodePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    @Generated
    private LockNode() {
    }
}

