/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml.impl;

import java.util.List;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.dml.ShardingDMLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.DeleteStatementHandler;

public final class ShardingDeleteStatementValidator
extends ShardingDMLStatementValidator<DeleteStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<DeleteStatement> sqlStatementContext, List<Object> parameters, ShardingSphereSchema schema) {
        this.validateMultipleTable(shardingRule, sqlStatementContext);
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<DeleteStatement> sqlStatementContext, RouteContext routeContext, ShardingSphereSchema schema) {
        if (DeleteStatementHandler.getLimitSegment((DeleteStatement)((DeleteStatement)sqlStatementContext.getSqlStatement())).isPresent() && routeContext.getRouteUnits().size() > 1) {
            throw new ShardingSphereException("DELETE ... LIMIT can not support sharding route to multiple data nodes.", new Object[0]);
        }
    }
}

