/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml;

import java.util.Collection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class ShardingDMLStatementValidator<T extends SQLStatement>
implements ShardingStatementValidator<T> {
    protected void validateMultipleTable(ShardingRule shardingRule, SQLStatementContext<T> sqlStatementContext) {
        boolean isAllSingleTables;
        Collection tableNames = sqlStatementContext.getTablesContext().getTableNames();
        boolean isAllShardingTables = shardingRule.isAllShardingTables(tableNames) && (1 == tableNames.size() || shardingRule.isAllBindingTables(tableNames));
        boolean isAllBroadcastTables = shardingRule.isAllBroadcastTables(tableNames);
        boolean bl = isAllSingleTables = !shardingRule.tableRuleExists(tableNames);
        if (!(isAllShardingTables || isAllBroadcastTables || isAllSingleTables)) {
            throw new ShardingSphereException("Cannot support Multiple-Table for '%s'.", new Object[]{tableNames});
        }
    }
}

