/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class ShardingDropIndexStatementValidator
extends ShardingDDLStatementValidator<DropIndexStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<DropIndexStatement> sqlStatementContext, List<Object> parameters, ShardingSphereSchema schema) {
        if (DropIndexStatementHandler.containsExistClause((DropIndexStatement)((DropIndexStatement)sqlStatementContext.getSqlStatement()))) {
            return;
        }
        for (IndexSegment each : ((DropIndexStatement)sqlStatementContext.getSqlStatement()).getIndexes()) {
            if (this.isSchemaContainsIndex(schema, each)) continue;
            throw new ShardingSphereException("Index '%s' does not exist.", new Object[]{each.getIdentifier().getValue()});
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<DropIndexStatement> sqlStatementContext, RouteContext routeContext, ShardingSphereSchema schema) {
        Collection indexNames = ((DropIndexStatement)sqlStatementContext.getSqlStatement()).getIndexes().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
        Optional<String> logicTableName = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)((DropIndexStatement)sqlStatementContext.getSqlStatement())).map(table -> table.getTableName().getIdentifier().getValue());
        if (logicTableName.isPresent()) {
            this.validateDropIndexRouteUnit(shardingRule, routeContext, indexNames, logicTableName.get());
        } else {
            for (String each2 : indexNames) {
                logicTableName = schema.getAllTableNames().stream().filter(tableName -> schema.get(tableName).getIndexes().containsKey(each2)).findFirst();
                logicTableName.ifPresent(tableName -> this.validateDropIndexRouteUnit(shardingRule, routeContext, indexNames, (String)tableName));
            }
        }
    }

    private void validateDropIndexRouteUnit(ShardingRule shardingRule, RouteContext routeContext, Collection<String> indexNames, String logicTableName) {
        if (this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, logicTableName)) {
            throw new ShardingSphereException("DROP INDEX ... statement can not route correctly for indexes %s.", new Object[]{indexNames});
        }
    }
}

