/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.datetime.DatetimeService;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;

public final class ConditionValueCompareOperatorGenerator
implements ConditionValueGenerator<BinaryOperationExpression> {
    private static final String EQUAL = "=";
    private static final String GREATER_THAN = ">";
    private static final String LESS_THAN = "<";
    private static final String AT_MOST = "<=";
    private static final String AT_LEAST = ">=";
    private static final Collection<String> OPERATORS = Sets.newHashSet((Object[])new String[]{"=", ">", "<", ">=", "<="});

    @Override
    public Optional<ShardingConditionValue> generate(BinaryOperationExpression predicate, Column column, List<Object> parameters) {
        String operator = predicate.getOperator();
        if (!this.isSupportedOperator(operator)) {
            return Optional.empty();
        }
        ExpressionSegment valueExpression = predicate.getLeft() instanceof ColumnSegment ? predicate.getRight() : predicate.getLeft();
        Optional<Comparable<?>> conditionValue = new ConditionValue(valueExpression, parameters).getValue();
        if (conditionValue.isPresent()) {
            return this.generate(conditionValue.get(), column, operator);
        }
        if (ExpressionConditionUtils.isNowExpression(valueExpression)) {
            return this.generate(((DatetimeService)RequiredSPIRegistry.getRegisteredService(DatetimeService.class)).getDatetime(), column, operator);
        }
        return Optional.empty();
    }

    private Optional<ShardingConditionValue> generate(Comparable<?> comparable, Column column, String operator) {
        String columnName = column.getName();
        String tableName = column.getTableName();
        switch (operator) {
            case "=": {
                return Optional.of(new ListShardingConditionValue(columnName, tableName, Lists.newArrayList((Object[])new Comparable[]{comparable})));
            }
            case ">": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.greaterThan(comparable)));
            }
            case "<": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.lessThan(comparable)));
            }
            case "<=": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.atMost(comparable)));
            }
            case ">=": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.atLeast(comparable)));
            }
        }
        return Optional.empty();
    }

    private boolean isSupportedOperator(String operator) {
        return OPERATORS.contains(operator);
    }
}

