/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class ConditionValue {
    private final Comparable<?> value;

    public ConditionValue(ExpressionSegment expressionSegment, List<Object> parameters) {
        this.value = this.getValue(expressionSegment, parameters);
    }

    private Comparable<?> getValue(ExpressionSegment expressionSegment, List<Object> parameters) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            return this.getValue((ParameterMarkerExpressionSegment)expressionSegment, parameters);
        }
        if (expressionSegment instanceof LiteralExpressionSegment) {
            return this.getValue((LiteralExpressionSegment)expressionSegment);
        }
        return null;
    }

    private Comparable<?> getValue(ParameterMarkerExpressionSegment expressionSegment, List<Object> parameters) {
        int parameterMarkerIndex = expressionSegment.getParameterMarkerIndex();
        Preconditions.checkArgument((parameterMarkerIndex < parameters.size() ? 1 : 0) != 0, (Object)"Parameter marker expression must have corresponding parameter value.");
        Object result = parameters.get(parameterMarkerIndex);
        Preconditions.checkArgument((boolean)(result instanceof Comparable), (Object)"Sharding value must implements Comparable.");
        return (Comparable)result;
    }

    private Comparable<?> getValue(LiteralExpressionSegment expressionSegment) {
        Object result = expressionSegment.getLiterals();
        Preconditions.checkArgument((boolean)(result instanceof Comparable), (Object)"Sharding value must implements Comparable.");
        return (Comparable)result;
    }

    public Optional<Comparable<?>> getValue() {
        return Optional.ofNullable(this.value);
    }
}

