/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateIndexStatementContext;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.util.IndexMetaDataUtil;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class IndexToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue identifier;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;
    private final ShardingSphereSchema schema;

    public IndexToken(int startIndex, int stopIndex, IdentifierValue identifier, SQLStatementContext sqlStatementContext, ShardingRule shardingRule, ShardingSphereSchema schema) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
        this.schema = schema;
    }

    public String toString(RouteUnit routeUnit) {
        String quotedIndexName = this.identifier.getQuoteCharacter().wrap(this.getIndexValue(routeUnit));
        return this.isGeneratedIndex() ? " " + quotedIndexName + " " : quotedIndexName;
    }

    private boolean isGeneratedIndex() {
        return this.sqlStatementContext instanceof CreateIndexStatementContext && ((CreateIndexStatementContext)this.sqlStatementContext).isGeneratedIndex();
    }

    private String getIndexValue(RouteUnit routeUnit) {
        Map<String, String> logicAndActualTables = this.getLogicAndActualTables(routeUnit);
        String actualTableName = this.findLogicTableNameFromMetaData(this.identifier.getValue()).map(logicAndActualTables::get).orElseGet(() -> logicAndActualTables.values().stream().findFirst().orElse(null));
        return IndexMetaDataUtil.getActualIndexName((String)this.identifier.getValue(), (String)actualTableName);
    }

    private Optional<String> findLogicTableNameFromMetaData(String logicIndexName) {
        for (String each : this.schema.getAllTableNames()) {
            if (!this.schema.get(each).getIndexes().containsKey(logicIndexName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        Collection tableNames = this.sqlStatementContext.getTablesContext().getTableNames();
        HashMap<String, String> result = new HashMap<String, String>(tableNames.size(), 1.0f);
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
            result.putAll(this.shardingRule.getLogicAndActualTablesFromBindingTable(routeUnit.getDataSourceMapper().getLogicName(), each.getLogicName(), each.getActualName(), tableNames));
        }
        return result;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

