/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoaderEngine;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.RuleBasedTableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.builder.util.TableMetaDataUtil;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingTableMetaDataBuilder
implements RuleBasedTableMetaDataBuilder<ShardingRule> {
    public Map<String, TableMetaData> load(Collection<String> tableNames, ShardingRule rule, SchemaBuilderMaterials materials) throws SQLException {
        Collection needLoadTables = tableNames.stream().filter(each -> rule.findTableRule((String)each).isPresent() || rule.isBroadcastTable((String)each)).collect(Collectors.toList());
        if (needLoadTables.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean isCheckingMetaData = (Boolean)materials.getProps().getValue((Enum)ConfigurationPropertyKey.CHECK_TABLE_METADATA_ENABLED);
        Collection tableMetaDataLoaderMaterials = TableMetaDataUtil.getTableMetaDataLoadMaterial((Collection)needLoadTables, (SchemaBuilderMaterials)materials, (boolean)isCheckingMetaData);
        if (tableMetaDataLoaderMaterials.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection tableMetaDataList = TableMetaDataLoaderEngine.load((Collection)tableMetaDataLoaderMaterials, (DatabaseType)materials.getDatabaseType());
        if (isCheckingMetaData) {
            this.checkTableMetaData(tableMetaDataList, rule);
        }
        return this.getTableMetaDataMap(tableMetaDataList, rule);
    }

    private void checkTableMetaData(Collection<TableMetaData> tableMetaDataList, ShardingRule rule) {
        LinkedHashMap<String, Collection> logicTableMetaDataMap = new LinkedHashMap<String, Collection>();
        for (TableMetaData tableMetaData : tableMetaDataList) {
            Optional<String> logicName = rule.findLogicTableByActualTable(tableMetaData.getName());
            if (!logicName.isPresent()) continue;
            Collection logicTableMetaDataList = logicTableMetaDataMap.getOrDefault(logicName.get(), new LinkedList());
            logicTableMetaDataList.add(tableMetaData);
            logicTableMetaDataMap.putIfAbsent(logicName.get(), logicTableMetaDataList);
        }
        for (Map.Entry entry : logicTableMetaDataMap.entrySet()) {
            this.checkUniformed((String)entry.getKey(), (Collection)entry.getValue(), rule);
        }
    }

    private Map<String, TableMetaData> getTableMetaDataMap(Collection<TableMetaData> tableMetaDataList, ShardingRule rule) {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        for (TableMetaData each : tableMetaDataList) {
            result.putIfAbsent(rule.findLogicTableByActualTable(each.getName()).orElse(each.getName()), each);
        }
        return result;
    }

    private void checkUniformed(String logicTableName, Collection<TableMetaData> tableMetaDataList, ShardingRule shardingRule) {
        TableMetaData sample = this.decorate(logicTableName, tableMetaDataList.iterator().next(), shardingRule);
        Collection violations = tableMetaDataList.stream().filter(each -> !sample.equals((Object)this.decorate(logicTableName, (TableMetaData)each, shardingRule))).map(each -> new TableMetaDataViolation(each.getName(), (TableMetaData)each)).collect(Collectors.toList());
        this.throwExceptionIfNecessary(violations, logicTableName);
    }

    private void throwExceptionIfNecessary(Collection<TableMetaDataViolation> violations, String logicTableName) {
        if (!violations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Cannot get uniformed table structure for logic table `%s`, it has different meta data of actual tables are as follows:").append(System.lineSeparator());
            for (TableMetaDataViolation each : violations) {
                errorMessage.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(System.lineSeparator());
            }
            throw new ShardingSphereException(errorMessage.toString(), new Object[]{logicTableName});
        }
    }

    public TableMetaData decorate(String tableName, TableMetaData tableMetaData, ShardingRule shardingRule) {
        return shardingRule.findTableRule(tableName).map(tableRule -> new TableMetaData(tableName, this.getColumnMetaDataList(tableMetaData, (TableRule)tableRule), this.getIndexMetaDataList(tableMetaData, (TableRule)tableRule))).orElse(tableMetaData);
    }

    private Collection<ColumnMetaData> getColumnMetaDataList(TableMetaData tableMetaData, TableRule tableRule) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (Map.Entry entry : tableMetaData.getColumns().entrySet()) {
            boolean generated = ((String)entry.getKey()).equalsIgnoreCase(tableRule.getGenerateKeyColumn().orElse(null));
            ColumnMetaData columnMetaData = (ColumnMetaData)entry.getValue();
            result.add(new ColumnMetaData(columnMetaData.getName(), columnMetaData.getDataType(), columnMetaData.isPrimaryKey(), generated, columnMetaData.isCaseSensitive()));
        }
        return result;
    }

    private Collection<IndexMetaData> getIndexMetaDataList(TableMetaData tableMetaData, TableRule tableRule) {
        HashSet<IndexMetaData> result = new HashSet<IndexMetaData>();
        for (Map.Entry entry : tableMetaData.getIndexes().entrySet()) {
            for (DataNode each : tableRule.getActualDataNodes()) {
                this.getLogicIndex((String)entry.getKey(), each.getTableName()).ifPresent(logicIndex -> result.add(new IndexMetaData(logicIndex)));
            }
        }
        return result;
    }

    private Optional<String> getLogicIndex(String actualIndexName, String actualTableName) {
        String indexNameSuffix = "_" + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? Optional.of(actualIndexName.replace(indexNameSuffix, "")) : Optional.empty();
    }

    public int getOrder() {
        return -10;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }

    private static final class TableMetaDataViolation {
        private final String actualTableName;
        private final TableMetaData tableMetaData;

        @Generated
        public TableMetaDataViolation(String actualTableName, TableMetaData tableMetaData) {
            this.actualTableName = actualTableName;
            this.tableMetaData = tableMetaData;
        }

        @Generated
        public String getActualTableName() {
            return this.actualTableName;
        }

        @Generated
        public TableMetaData getTableMetaData() {
            return this.tableMetaData;
        }
    }
}

