/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public class LogicTablesMergedResult
extends MemoryMergedResult<ShardingRule> {
    public LogicTablesMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super((ShardingSphereRule)shardingRule, schema, sqlStatementContext, queryResults);
    }

    protected final List<MemoryQueryResultRow> init(ShardingRule shardingRule, ShardingSphereSchema schema, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        HashSet<String> tableNames = new HashSet<String>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional<TableRule> tableRule = shardingRule.findTableRuleByActualTable(actualTableName);
                if (!tableRule.isPresent()) {
                    if (!shardingRule.getTableRules().isEmpty() && !tableNames.add(actualTableName)) continue;
                    this.setCellValue(memoryResultSetRow, actualTableName, actualTableName, schema.get(actualTableName));
                    result.add(memoryResultSetRow);
                    continue;
                }
                if (!tableNames.add(tableRule.get().getLogicTable())) continue;
                String logicTableName = tableRule.get().getLogicTable();
                memoryResultSetRow.setCell(1, (Object)logicTableName);
                this.setCellValue(memoryResultSetRow, logicTableName, actualTableName, schema.get(logicTableName));
                result.add(memoryResultSetRow);
            }
        }
        return result;
    }

    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, TableMetaData tableMetaData) {
    }
}

