/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.rewrite.util.EncryptPropertiesBuilder;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class EncryptRule
implements SchemaRule,
TableContainedRule {
    private final Map<String, EncryptAlgorithm> encryptors = new LinkedHashMap<String, EncryptAlgorithm>();
    private final Map<String, EncryptTable> tables = new LinkedHashMap<String, EncryptTable>();
    private final boolean queryWithCipherColumn;

    public EncryptRule(EncryptRuleConfiguration config) {
        Preconditions.checkArgument((boolean)this.isValidRuleConfiguration(config), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        config.getEncryptors().forEach((key, value) -> this.encryptors.put((String)key, (EncryptAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, EncryptAlgorithm.class)));
        config.getTables().forEach(each -> this.tables.put(each.getName(), new EncryptTable((EncryptTableRuleConfiguration)each)));
        this.queryWithCipherColumn = config.isQueryWithCipherColumn();
    }

    public EncryptRule(AlgorithmProvidedEncryptRuleConfiguration config) {
        Preconditions.checkArgument((boolean)this.isValidRuleConfigurationWithAlgorithmProvided(config), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        this.encryptors.putAll(config.getEncryptors());
        config.getTables().forEach(each -> this.tables.put(each.getName(), new EncryptTable((EncryptTableRuleConfiguration)each)));
        this.queryWithCipherColumn = config.isQueryWithCipherColumn();
    }

    private boolean isValidRuleConfiguration(EncryptRuleConfiguration config) {
        return config.getEncryptors().isEmpty() && config.getTables().isEmpty() || this.isValidTableConfiguration(config);
    }

    private boolean isValidTableConfiguration(EncryptRuleConfiguration config) {
        for (EncryptTableRuleConfiguration table : config.getTables()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns()) {
                if (this.isValidColumnConfiguration(config, column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfiguration(EncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptorName()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && this.containsEncryptors(encryptRuleConfig, column);
    }

    private boolean containsEncryptors(EncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return encryptRuleConfig.getEncryptors().keySet().stream().anyMatch(each -> each.equals(column.getEncryptorName()));
    }

    private boolean isValidRuleConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration config) {
        return config.getEncryptors().isEmpty() && config.getTables().isEmpty() || this.isValidTableConfigurationWithAlgorithmProvided(config);
    }

    private boolean isValidTableConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration config) {
        for (EncryptTableRuleConfiguration table : config.getTables()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns()) {
                if (this.isValidColumnConfigurationWithAlgorithmProvided(config, column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptorName()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && encryptRuleConfig.getEncryptors().containsKey(column.getEncryptorName());
    }

    public Optional<EncryptTable> findEncryptTable(String logicTable) {
        return Optional.ofNullable(this.tables.get(logicTable));
    }

    public Optional<EncryptAlgorithm> findEncryptor(String logicTable, String logicColumn) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findEncryptorName(logicColumn).map(this.encryptors::get) : Optional.empty();
    }

    public Optional<EncryptAlgorithm> findEncryptor(String schemaName, String logicTable, String logicColumn) {
        if (!this.tables.containsKey(logicTable)) {
            return Optional.empty();
        }
        Optional<EncryptAlgorithm> encryptAlgorithm = this.tables.get(logicTable).findEncryptorName(logicColumn).map(this.encryptors::get);
        encryptAlgorithm.ifPresent(optional -> this.mergeProps((EncryptAlgorithm)optional, EncryptPropertiesBuilder.getProperties(schemaName, "", logicTable, logicColumn)));
        return encryptAlgorithm;
    }

    private void mergeProps(EncryptAlgorithm encryptAlgorithm, Properties encryptProperties) {
        Properties props = encryptAlgorithm.getProps();
        props.putAll((Map<?, ?>)encryptProperties);
        encryptAlgorithm.setProps(props);
    }

    public List<Object> getEncryptValues(String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<EncryptAlgorithm> encryptor = this.findEncryptor(schemaName, logicTable, logicColumn);
        Preconditions.checkArgument((boolean)encryptor.isPresent(), (String)"Can not find QueryAssistedEncryptAlgorithm by %s.%s.", (Object)logicTable, (Object)logicColumn);
        return originalValues.stream().map(input -> null == input ? null : String.valueOf(((EncryptAlgorithm)encryptor.get()).encrypt((Object)input.toString()))).collect(Collectors.toList());
    }

    public String getCipherColumn(String logicTable, String logicColumn) {
        return this.tables.get(logicTable).getCipherColumn(logicColumn);
    }

    public Map<String, String> getLogicAndCipherColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getLogicAndCipherColumns() : Collections.emptyMap();
    }

    public Optional<String> findAssistedQueryColumn(String logicTable, String logicColumn) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findAssistedQueryColumn(logicColumn) : Optional.empty();
    }

    public Collection<String> getAssistedQueryColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getAssistedQueryColumns() : Collections.emptyList();
    }

    public List<Object> getEncryptAssistedQueryValues(String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<EncryptAlgorithm> encryptor = this.findEncryptor(schemaName, logicTable, logicColumn);
        Preconditions.checkArgument((encryptor.isPresent() && encryptor.get() instanceof QueryAssistedEncryptAlgorithm ? 1 : 0) != 0, (Object)String.format("Can not find QueryAssistedEncryptAlgorithm by %s.%s.", logicTable, logicColumn));
        return originalValues.stream().map(input -> null == input ? null : ((QueryAssistedEncryptAlgorithm)encryptor.get()).queryAssistedEncrypt(input)).collect(Collectors.toList());
    }

    public Optional<String> findPlainColumn(String logicTable, String logicColumn) {
        Optional<String> originColumnName = this.findOriginColumnName(logicTable, logicColumn);
        return originColumnName.isPresent() && this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findPlainColumn(originColumnName.get()) : Optional.empty();
    }

    public boolean isQueryWithCipherColumn(SQLStatementContext<?> sqlStatementContext) {
        String tableName;
        List simpleTables = sqlStatementContext instanceof SelectStatementContext ? ((TableAvailable)sqlStatementContext).getAllTables() : Collections.emptyList();
        boolean result = this.queryWithCipherColumn;
        if (!simpleTables.isEmpty() && this.tables.containsKey(tableName = ((SimpleTableSegment)simpleTables.iterator().next()).getTableName().getIdentifier().getValue()) && null != this.tables.get(tableName).getQueryWithCipherColumn()) {
            result = this.tables.get(tableName).getQueryWithCipherColumn();
        }
        return result;
    }

    private Optional<String> findOriginColumnName(String logicTable, String logicColumn) {
        for (String each : this.tables.get(logicTable).getLogicColumns()) {
            if (!logicColumn.equalsIgnoreCase(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Collection<String> getTables() {
        return this.tables.keySet();
    }

    public String getType() {
        return EncryptRule.class.getSimpleName();
    }

    @Generated
    public boolean isQueryWithCipherColumn() {
        return this.queryWithCipherColumn;
    }

    static {
        ShardingSphereServiceLoader.register(EncryptAlgorithm.class);
    }
}

