/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class EncryptProjectionTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
QueryWithCipherColumnAware,
PreviousSQLTokensAware {
    private boolean queryWithCipherColumn;
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getAllTables().isEmpty() || sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        if (sqlStatementContext instanceof InsertStatementContext) {
            result.addAll(this.generateSQLTokens(((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext(), true));
        }
        if (sqlStatementContext instanceof SelectStatementContext) {
            result.addAll(this.generateSQLTokens((SelectStatementContext)sqlStatementContext, false));
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(SelectStatementContext selectStatementContext, boolean insertSelect) {
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        ProjectionsSegment projectionsSegment = ((SelectStatement)selectStatementContext.getSqlStatement()).getProjections();
        for (String each : selectStatementContext.getTablesContext().getTableNames()) {
            this.getEncryptRule().findEncryptTable(each).map(optional -> this.generateSQLTokens(projectionsSegment, each, selectStatementContext, (EncryptTable)optional, insertSelect)).ifPresent(result::addAll);
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(ProjectionsSegment segment, String tableName, SelectStatementContext selectStatementContext, EncryptTable encryptTable, boolean insertSelect) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ProjectionSegment each : segment.getProjections()) {
            ShorthandProjection shorthandProjection;
            if (each instanceof ColumnProjectionSegment && encryptTable.getLogicColumns().contains(((ColumnProjectionSegment)each).getColumn().getIdentifier().getValue()) && this.columnMatchTableAndCheckAmbiguous(selectStatementContext, (ColumnProjectionSegment)each, tableName)) {
                result.add(this.generateSQLToken((ColumnProjectionSegment)each, tableName, insertSelect));
            }
            if (!this.isToGeneratedSQLToken(each, selectStatementContext, tableName) || (shorthandProjection = this.getShorthandProjection((ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext())).getActualColumns().isEmpty()) continue;
            result.add(this.generateSQLToken((ShorthandProjectionSegment)each, shorthandProjection, tableName, encryptTable, selectStatementContext.getDatabaseType()));
        }
        return result;
    }

    private boolean columnMatchTableAndCheckAmbiguous(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnProjectionSegment, String tableName) {
        return this.isOwnerExistsMatchTableAlias(selectStatementContext, columnProjectionSegment, tableName) || this.isOwnerExistsMatchTableName(selectStatementContext, columnProjectionSegment, tableName) || this.isColumnUnAmbiguous(selectStatementContext, columnProjectionSegment);
    }

    private boolean isOwnerExistsMatchTableAlias(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnProjectionSegment, String tableName) {
        if (!columnProjectionSegment.getColumn().getOwner().isPresent()) {
            return false;
        }
        return selectStatementContext.getTablesContext().getAllUniqueTables().stream().anyMatch(table -> tableName.equals(table.getTableName().getIdentifier().getValue()) && table.getAlias().isPresent() && ((OwnerSegment)columnProjectionSegment.getColumn().getOwner().get()).getIdentifier().getValue().equals(table.getAlias().get()));
    }

    private boolean isOwnerExistsMatchTableName(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnProjectionSegment, String tableName) {
        if (!columnProjectionSegment.getColumn().getOwner().isPresent()) {
            return false;
        }
        return selectStatementContext.getTablesContext().getAllUniqueTables().stream().anyMatch(table -> tableName.equals(table.getTableName().getIdentifier().getValue()) && !table.getAlias().isPresent() && ((OwnerSegment)columnProjectionSegment.getColumn().getOwner().get()).getIdentifier().getValue().equals(tableName));
    }

    private boolean isColumnUnAmbiguous(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnProjectionSegment) {
        if (columnProjectionSegment.getColumn().getOwner().isPresent()) {
            return false;
        }
        int columnCount = 0;
        for (String each : selectStatementContext.getTablesContext().getTableNames()) {
            Optional<EncryptTable> encryptTable = this.getEncryptRule().findEncryptTable(each);
            if (!encryptTable.isPresent() || !encryptTable.get().getLogicColumns().contains(columnProjectionSegment.getColumn().getIdentifier().getValue())) continue;
            ++columnCount;
        }
        Preconditions.checkState((columnCount <= 1 ? 1 : 0) != 0, (String)"column `%s` is ambiguous in encrypt rules", (Object)columnProjectionSegment.getColumn().getIdentifier().getValue());
        return true;
    }

    private boolean isToGeneratedSQLToken(ProjectionSegment projectionSegment, SelectStatementContext selectStatementContext, String tableName) {
        if (!(projectionSegment instanceof ShorthandProjectionSegment)) {
            return false;
        }
        Optional ownerSegment = ((ShorthandProjectionSegment)projectionSegment).getOwner();
        return ownerSegment.map(segment -> selectStatementContext.getTablesContext().findTableNameFromSQL(segment.getIdentifier().getValue()).orElse("").equalsIgnoreCase(tableName)).orElse(true);
    }

    private SubstitutableColumnNameToken generateSQLToken(ColumnProjectionSegment segment, String tableName, boolean insertSelect) {
        String encryptColumnName = this.getEncryptColumnName(tableName, segment.getColumn().getIdentifier().getValue());
        LinkedList<ColumnProjection> projections = new LinkedList<ColumnProjection>();
        if (insertSelect) {
            projections.add(new ColumnProjection(null, encryptColumnName, null));
            Optional<String> assistedQueryColumn = this.findAssistedQueryColumn(tableName, segment.getColumn().getIdentifier().getValue());
            assistedQueryColumn.ifPresent(each -> projections.add(new ColumnProjection(null, (String)assistedQueryColumn.get(), null)));
            Optional<String> plainColumn = this.getEncryptRule().findPlainColumn(tableName, segment.getColumn().getIdentifier().getValue());
            plainColumn.ifPresent(each -> projections.add(new ColumnProjection(null, (String)plainColumn.get(), null)));
        } else {
            String alias = segment.getAlias().orElse(segment.getColumn().getIdentifier().getValue());
            projections.addAll(Collections.singletonList(new ColumnProjection(null, encryptColumnName, alias)));
        }
        return segment.getColumn().getOwner().isPresent() ? new SubstitutableColumnNameToken(((OwnerSegment)segment.getColumn().getOwner().get()).getStopIndex() + 2, segment.getStopIndex(), projections) : new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), projections);
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, ShorthandProjection shorthandProjection, String tableName, EncryptTable encryptTable, DatabaseType databaseType) {
        LinkedList<ColumnProjection> projections = new LinkedList<ColumnProjection>();
        for (ColumnProjection each2 : shorthandProjection.getActualColumns().values()) {
            if (encryptTable.getLogicColumns().contains(each2.getName())) {
                projections.add(new ColumnProjection(null == each2.getOwner() ? null : each2.getOwner(), this.getEncryptColumnName(tableName, each2.getName()), each2.getName()));
                continue;
            }
            projections.add(new ColumnProjection(null == each2.getOwner() ? null : each2.getOwner(), each2.getName(), null));
        }
        this.previousSQLTokens.removeIf(each -> each.getStartIndex() == segment.getStartIndex());
        return new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), projections, databaseType.getQuoteCharacter());
    }

    private Optional<String> findAssistedQueryColumn(String tableName, String logicEncryptColumnName) {
        Optional<String> plainColumn = this.getEncryptRule().findPlainColumn(tableName, logicEncryptColumnName);
        return plainColumn.isPresent() && !this.queryWithCipherColumn ? plainColumn : this.getEncryptRule().findAssistedQueryColumn(tableName, logicEncryptColumnName);
    }

    private String getEncryptColumnName(String tableName, String logicEncryptColumnName) {
        Optional<String> plainColumn = this.getEncryptRule().findPlainColumn(tableName, logicEncryptColumnName);
        return plainColumn.isPresent() && !this.queryWithCipherColumn ? plainColumn.get() : this.getEncryptRule().getCipherColumn(tableName, logicEncryptColumnName);
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is: `%s`", owner.orElse(null)));
    }

    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

