/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertColumnsToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class AssistQueryAndPlainInsertColumnsTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof InsertStatementContext) {
            return ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getInsertColumns().isPresent() && !((InsertStatementContext)sqlStatementContext).useDefaultColumns();
        }
        return false;
    }

    public Collection<InsertColumnsToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        LinkedList<InsertColumnsToken> result = new LinkedList<InsertColumnsToken>();
        Optional<EncryptTable> encryptTable = this.getEncryptRule().findEncryptTable(((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue());
        Preconditions.checkState((boolean)encryptTable.isPresent());
        for (ColumnSegment each : ((InsertStatement)insertStatementContext.getSqlStatement()).getColumns()) {
            List<String> columns = this.getColumns(encryptTable.get(), each);
            if (columns.isEmpty()) continue;
            result.add(new InsertColumnsToken(each.getStopIndex() + 1, columns));
        }
        return result;
    }

    private List<String> getColumns(EncryptTable encryptTable, ColumnSegment columnSegment) {
        LinkedList<String> result = new LinkedList<String>();
        encryptTable.findAssistedQueryColumn(columnSegment.getIdentifier().getValue()).ifPresent(result::add);
        encryptTable.findPlainColumn(columnSegment.getIdentifier().getValue()).ifPresent(result::add);
        return result;
    }
}

