/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptEqualCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.util.DMLStatementContextHelper;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class EncryptConditionEngine {
    private final EncryptRule encryptRule;
    private final ShardingSphereSchema schema;

    public Collection<EncryptCondition> createEncryptConditions(SQLStatementContext sqlStatementContext) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        result.addAll(this.createEncryptConditionsOnWhereSegment(sqlStatementContext));
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            SelectStatementContext selectStatementContext = ((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext();
            result.addAll(this.createEncryptConditionsOnWhereSegment((SQLStatementContext)selectStatementContext));
        }
        return result;
    }

    private Collection<EncryptCondition> createEncryptConditions(String schemaName, Collection<ExpressionSegment> predicates, Map<String, String> columnTableNames) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        HashSet<Integer> stopIndexes = new HashSet<Integer>();
        for (ExpressionSegment each : predicates) {
            if (!stopIndexes.add(each.getStopIndex())) continue;
            result.addAll(this.createEncryptConditions(schemaName, each, columnTableNames));
        }
        return result;
    }

    private Collection<EncryptCondition> createEncryptConditions(String schemaName, ExpressionSegment expression, Map<String, String> columnTableNames) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        for (ColumnSegment each : ColumnExtractor.extract((ExpressionSegment)expression)) {
            Optional<String> tableName = Optional.ofNullable(columnTableNames.get(each.getQualifiedName()));
            Optional<EncryptCondition> encryptCondition = tableName.isPresent() && this.encryptRule.findEncryptor(schemaName, tableName.get(), each.getIdentifier().getValue()).isPresent() ? this.createEncryptCondition(expression, tableName.get()) : Optional.empty();
            encryptCondition.ifPresent(result::add);
        }
        return result;
    }

    private Optional<EncryptCondition> createEncryptCondition(ExpressionSegment expression, String tableName) {
        if (expression instanceof BinaryOperationExpression) {
            boolean logical;
            String operator = ((BinaryOperationExpression)expression).getOperator();
            boolean bl = logical = "and".equalsIgnoreCase(operator) || "&&".equalsIgnoreCase(operator) || "OR".equalsIgnoreCase(operator) || "||".equalsIgnoreCase(operator);
            if (!logical) {
                ExpressionSegment rightValue = ((BinaryOperationExpression)expression).getRight();
                return this.isSupportedOperator(((BinaryOperationExpression)expression).getOperator()) ? EncryptConditionEngine.createCompareEncryptCondition(tableName, (BinaryOperationExpression)expression, rightValue) : Optional.empty();
            }
        }
        if (expression instanceof InExpression) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, (InExpression)expression, ((InExpression)expression).getRight());
        }
        if (expression instanceof BetweenExpression) {
            throw new ShardingSphereException("The SQL clause 'BETWEEN...AND...' is unsupported in encrypt rule.", new Object[0]);
        }
        return Optional.empty();
    }

    private Collection<EncryptCondition> createEncryptConditionsOnWhereSegment(SQLStatementContext sqlStatementContext) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Optional whereSegment = ((WhereAvailable)sqlStatementContext).getWhere();
        if (!whereSegment.isPresent()) {
            return Collections.emptyList();
        }
        Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)((WhereSegment)whereSegment.get()).getExpr());
        Map<String, String> columnTableNames = this.getColumnTableNames(sqlStatementContext, andPredicates);
        String schemaName = DMLStatementContextHelper.getSchemaName((SQLStatementContext)sqlStatementContext);
        for (AndPredicate each : andPredicates) {
            result.addAll(this.createEncryptConditions(schemaName, each.getPredicates(), columnTableNames));
        }
        return result;
    }

    private Map<String, String> getColumnTableNames(SQLStatementContext<?> sqlStatementContext, Collection<AndPredicate> andPredicates) {
        Collection columns = andPredicates.stream().flatMap(each -> each.getPredicates().stream()).flatMap(each -> ColumnExtractor.extract((ExpressionSegment)each).stream()).collect(Collectors.toList());
        return sqlStatementContext.getTablesContext().findTableName(columns, this.schema);
    }

    private static Optional<EncryptCondition> createCompareEncryptCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        if (!(expression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        return compareRightValue instanceof SimpleExpressionSegment ? Optional.of(new EncryptEqualCondition(((ColumnSegment)expression.getLeft()).getIdentifier().getValue(), tableName, compareRightValue.getStartIndex(), expression.getStopIndex(), compareRightValue)) : Optional.empty();
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, InExpression inExpression, ExpressionSegment inRightValue) {
        if (!(inExpression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inExpression.getExpressionList()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        return Optional.of(new EncryptInCondition(((ColumnSegment)inExpression.getLeft()).getIdentifier().getValue(), tableName, inRightValue.getStartIndex(), inRightValue.getStopIndex(), expressionSegments));
    }

    private boolean isSupportedOperator(String operator) {
        return "=".equals(operator) || "<>".equals(operator) || "!=".equals(operator);
    }

    @Generated
    public EncryptConditionEngine(EncryptRule encryptRule, ShardingSphereSchema schema) {
        this.encryptRule = encryptRule;
        this.schema = schema;
    }
}

