/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;

public final class AESEncryptAlgorithm
implements EncryptAlgorithm {
    private static final String AES_KEY = "aes-key-value";
    private Properties props = new Properties();
    private byte[] secretKey;

    public void init() {
        this.secretKey = this.createSecretKey();
    }

    private byte[] createSecretKey() {
        Preconditions.checkArgument((boolean)this.props.containsKey(AES_KEY), (String)"%s can not be null.", (Object)AES_KEY);
        return Arrays.copyOf(DigestUtils.sha1((String)this.props.getProperty(AES_KEY)), 16);
    }

    public String encrypt(Object plaintext) {
        if (null == plaintext) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(String.valueOf(plaintext).getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printBase64Binary((byte[])result);
    }

    public Object decrypt(String ciphertext) {
        if (null == ciphertext) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(DatatypeConverter.parseBase64Binary((String)ciphertext));
        return new String(result, StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int decryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.secretKey, this.getType()));
        return result;
    }

    public String getType() {
        return "AES";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }
}

