/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.from.impl;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.optimize.converter.statement.SelectStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SubqueryTableConverter
implements SQLSegmentConverter<SubqueryTableSegment, SqlBasicCall> {
    @Override
    public Optional<SqlBasicCall> convertToSQLNode(SubqueryTableSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        LinkedList<SqlNode> sqlNodes = new LinkedList<SqlNode>();
        sqlNodes.add(new SelectStatementConverter().convertToSQLNode(segment.getSubquery().getSelect()));
        segment.getAlias().ifPresent(optional -> sqlNodes.add((SqlNode)new SqlIdentifier(optional, SqlParserPos.ZERO)));
        return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO));
    }

    @Override
    public Optional<SubqueryTableSegment> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        SqlNode select = (SqlNode)sqlBasicCall.getOperandList().get(0);
        SelectStatement selectStatement = new SelectStatementConverter().convertToSQLStatement(select);
        SubqueryTableSegment result = new SubqueryTableSegment(new SubquerySegment(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), selectStatement));
        if (sqlBasicCall.getOperator().equals((Object)SqlStdOperatorTable.AS)) {
            SqlNode alias = (SqlNode)sqlBasicCall.getOperandList().get(1);
            result.setAlias(new AliasSegment(this.getStartIndex(alias), this.getStopIndex(alias), new IdentifierValue(alias.toString())));
        }
        return Optional.of(result);
    }
}

