/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.CacheNode;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaBasedPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class SchemaRulePersistService
implements SchemaBasedPersistService<Collection<RuleConfiguration>> {
    private final PersistRepository repository;

    @Override
    public void persist(String schemaName, Collection<RuleConfiguration> configs, boolean isOverwrite) {
        if (!(configs.isEmpty() || !isOverwrite && this.isExisted(schemaName))) {
            this.persist(schemaName, configs);
        }
    }

    @Override
    public void persist(String schemaName, Collection<RuleConfiguration> configs) {
        this.repository.persist(SchemaMetaDataNode.getRulePath(schemaName), YamlEngine.marshal(this.createYamlRuleConfigurations(configs)));
    }

    private Collection<YamlRuleConfiguration> createYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(ruleConfigs);
    }

    @Override
    public Collection<RuleConfiguration> load(String schemaName) {
        return this.isExisted(schemaName) ? new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations((Collection)YamlEngine.unmarshal((String)this.repository.get(SchemaMetaDataNode.getRulePath(schemaName)), Collection.class)) : new LinkedList<RuleConfiguration>();
    }

    @Override
    public boolean isExisted(String schemaName) {
        return !Strings.isNullOrEmpty((String)this.repository.get(SchemaMetaDataNode.getRulePath(schemaName)));
    }

    @Override
    public void cache(String schemaName, Collection<RuleConfiguration> configs) {
        this.repository.persist(CacheNode.getCachePath(SchemaMetaDataNode.getRulePath(schemaName)), YamlEngine.marshal(this.createYamlRuleConfigurations(configs)));
    }

    @Generated
    public SchemaRulePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

