/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlSchema;
import org.apache.shardingsphere.infra.yaml.schema.swapper.SchemaYamlSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class SchemaMetaDataPersistService {
    private final PersistRepository repository;

    public void persist(String schemaName, ShardingSphereSchema schema) {
        String content = null == schema ? "" : YamlEngine.marshal((Object)new SchemaYamlSwapper().swapToYamlConfiguration(schema));
        this.repository.persist(SchemaMetaDataNode.getMetaDataSchemaPath(schemaName), content);
    }

    public void delete(String schemaName) {
        this.repository.delete(SchemaMetaDataNode.getSchemaNamePath(schemaName));
    }

    public Optional<ShardingSphereSchema> load(String schemaName) {
        String path = this.repository.get(SchemaMetaDataNode.getMetaDataSchemaPath(schemaName));
        return Strings.isNullOrEmpty((String)path) ? Optional.empty() : Optional.of(new SchemaYamlSwapper().swapToObject((YamlSchema)YamlEngine.unmarshal((String)path, YamlSchema.class)));
    }

    public Collection<String> loadAllNames() {
        return this.repository.getChildrenKeys(SchemaMetaDataNode.getMetaDataNodePath());
    }

    @Generated
    public SchemaMetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

