/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.DataSourcePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.GlobalRulePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.PropertiesPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.SchemaRulePersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class MetaDataPersistService {
    private final PersistRepository repository;
    private final DataSourcePersistService dataSourceService;
    private final SchemaMetaDataPersistService schemaMetaDataService;
    private final SchemaRulePersistService schemaRuleService;
    private final GlobalRulePersistService globalRuleService;
    private final PropertiesPersistService propsService;

    public MetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.dataSourceService = new DataSourcePersistService(repository);
        this.schemaMetaDataService = new SchemaMetaDataPersistService(repository);
        this.schemaRuleService = new SchemaRulePersistService(repository);
        this.globalRuleService = new GlobalRulePersistService(repository);
        this.propsService = new PropertiesPersistService(repository);
    }

    public void persistConfigurations(Map<String, Map<String, DataSourceConfiguration>> dataSourceConfigs, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean isOverwrite) {
        this.globalRuleService.persist(globalRuleConfigs, isOverwrite);
        this.propsService.persist(props, isOverwrite);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : dataSourceConfigs.entrySet()) {
            String schemaName = entry.getKey();
            this.dataSourceService.persist(schemaName, dataSourceConfigs.get(schemaName), isOverwrite);
            this.schemaRuleService.persist(schemaName, schemaRuleConfigs.get(schemaName), isOverwrite);
        }
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public DataSourcePersistService getDataSourceService() {
        return this.dataSourceService;
    }

    @Generated
    public SchemaMetaDataPersistService getSchemaMetaDataService() {
        return this.schemaMetaDataService;
    }

    @Generated
    public SchemaRulePersistService getSchemaRuleService() {
        return this.schemaRuleService;
    }

    @Generated
    public GlobalRulePersistService getGlobalRuleService() {
        return this.globalRuleService;
    }

    @Generated
    public PropertiesPersistService getPropsService() {
        return this.propsService;
    }
}

