/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.schema.builder;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.provider.schema.model.privilege.SchemaPrivilegesPermittedShardingSpherePrivileges;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class SchemaPrivilegeBuilder {
    public static Map<ShardingSphereUser, ShardingSpherePrivileges> build(Collection<ShardingSphereUser> users, Properties props) {
        String mappingProp = props.getProperty("user-schema-mappings", "");
        SchemaPrivilegeBuilder.checkSchemas(mappingProp);
        return SchemaPrivilegeBuilder.buildPrivileges(users, mappingProp);
    }

    private static void checkSchemas(String mappingProp) {
        Preconditions.checkArgument((!"".equals(mappingProp) ? 1 : 0) != 0, (String)"user-schema-mappings configuration `%s` can not be null", (Object)mappingProp);
        Arrays.stream(mappingProp.split(",")).forEach(each -> Preconditions.checkArgument((0 < each.indexOf("@") && 0 < each.indexOf("=") ? 1 : 0) != 0, (String)"user-schema-mappings configuration `%s` is invalid, the configuration format should be like `username@hostname=schema`", (Object)each));
    }

    private static Map<ShardingSphereUser, ShardingSpherePrivileges> buildPrivileges(Collection<ShardingSphereUser> users, String mappingProp) {
        Map<ShardingSphereUser, Set<String>> userSchemaMappings = SchemaPrivilegeBuilder.convertSchemas(mappingProp);
        HashMap<ShardingSphereUser, ShardingSpherePrivileges> result = new HashMap<ShardingSphereUser, ShardingSpherePrivileges>(users.size(), 1.0f);
        users.forEach(each -> {
            ShardingSpherePrivileges cfr_ignored_0 = result.put((ShardingSphereUser)each, new SchemaPrivilegesPermittedShardingSpherePrivileges(SchemaPrivilegeBuilder.getUserSchemas(each, userSchemaMappings)));
        });
        return result;
    }

    private static Map<ShardingSphereUser, Set<String>> convertSchemas(String mappingProp) {
        String[] mappings = mappingProp.split(",");
        HashMap<ShardingSphereUser, Set<String>> result = new HashMap<ShardingSphereUser, Set<String>>(mappings.length, 1.0f);
        Arrays.asList(mappings).forEach(each -> {
            String[] userSchemaPair = each.trim().split("=");
            String yamlUser = userSchemaPair[0];
            String username = yamlUser.substring(0, yamlUser.indexOf("@"));
            String hostname = yamlUser.substring(yamlUser.indexOf("@") + 1);
            ShardingSphereUser shardingSphereUser = new ShardingSphereUser(username, "", hostname);
            Set schemas = result.getOrDefault(shardingSphereUser, new HashSet());
            schemas.add(userSchemaPair[1]);
            result.putIfAbsent(shardingSphereUser, schemas);
        });
        return result;
    }

    private static Set<String> getUserSchemas(ShardingSphereUser shardingSphereUser, Map<ShardingSphereUser, Set<String>> userSchemaMappings) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<ShardingSphereUser, Set<String>> entry : userSchemaMappings.entrySet()) {
            boolean isAnyOtherHost = SchemaPrivilegeBuilder.checkAnyOtherHost(entry.getKey().getGrantee(), shardingSphereUser);
            if (!isAnyOtherHost && shardingSphereUser != entry.getKey() && !shardingSphereUser.equals((Object)entry.getKey())) continue;
            result.addAll((Collection<String>)entry.getValue());
        }
        return result;
    }

    private static boolean checkAnyOtherHost(Grantee grantee, ShardingSphereUser shardingSphereUser) {
        return ("%".equalsIgnoreCase(grantee.getHostname()) || grantee.getHostname().equals(shardingSphereUser.getGrantee().getHostname())) && grantee.getUsername().equals(shardingSphereUser.getGrantee().getUsername());
    }

    @Generated
    private SchemaPrivilegeBuilder() {
    }
}

